/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.utils;

import com.openshift.restclient.model.IResource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.tools.openshift.internal.ui.models.IProjectWrapper;
import org.jboss.tools.openshift.internal.ui.models.IResourceWrapper;
import org.jboss.tools.openshift.internal.ui.models.IServiceWrapper;

public class ResourceWrapperUtils {
    private ResourceWrapperUtils() {
    }

    public static <R extends IResource> List<R> getResources(Collection<IResourceWrapper<?, ?>> wrappers) {
        if (wrappers == null || wrappers.isEmpty()) {
            return Collections.emptyList();
        }
        return wrappers.stream().map(wrapper -> (IResource)wrapper.getWrapped()).collect(Collectors.toList());
    }

    public static IResource getResource(Object element) {
        IResource resource = null;
        if (element != null) {
            if (element instanceof IResource) {
                resource = (IResource)element;
            } else if (element instanceof IResourceWrapper) {
                resource = (IResource)((IResourceWrapper)element).getWrapped();
            }
        }
        return resource;
    }

    public static IServiceWrapper getServiceWrapperFor(IResourceWrapper<?, ?> wrapper, Predicate<IResourceWrapper<?, ?>> predicate) {
        if (wrapper != null) {
            Object parent = wrapper.getParent();
            if (parent instanceof IServiceWrapper) {
                return (IServiceWrapper)parent;
            }
            if (parent instanceof IProjectWrapper) {
                Optional<IResourceWrapper<?, ?>> firstWrapper = ((IProjectWrapper)parent).getResourcesOfKind("Service").stream().filter(predicate).findFirst();
                return firstWrapper.orElse(null);
            }
        }
        return null;
    }
}

