/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.validator;

import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.internal.ui.validator.LabelValueValidator;

public class ProjectNameValidator
extends LabelValueValidator {
    public static final String projectNameDescription = "A valid project name must be 63 characters or less but at least 2 characters, excluding \"..\".\nIt may only contain lower-case letters, numbers, and dashes. It may not start or end with a dash.";
    private Pattern PROJECT_NAME_PATTERN = Pattern.compile("[a-z0-9]([-a-z0-9]*[a-z0-9])?");
    private String message;
    private Collection<String> unavailableNames;

    public ProjectNameValidator(String defaultMessage, Collection<String> unavailableNames) {
        super("project name");
        this.message = defaultMessage;
        this.unavailableNames = unavailableNames;
    }

    @Override
    public IStatus validate(Object value) {
        if (!(value instanceof String)) {
            return ValidationStatus.error((String)this.getValueIsNotAStringMessage());
        }
        String param = (String)value;
        if (StringUtils.isEmpty((String)param)) {
            return ValidationStatus.cancel((String)this.message);
        }
        if ("..".equals(param) || ".".equals(param)) {
            return ValidationStatus.error((String)"Project name cannot be '.' or '..'");
        }
        if (param.length() < 2) {
            return ValidationStatus.error((String)NLS.bind((String)"Project name length must be between {0} and {1} characters", (Object)2, (Object)63));
        }
        if (!this.PROJECT_NAME_PATTERN.matcher(param).matches()) {
            return ValidationStatus.error((String)"Project name may only contain lower-case letters, numbers, and dashes. It may not start or end with a dash");
        }
        if (this.unavailableNames != null && this.unavailableNames.contains(param)) {
            return ValidationStatus.error((String)"A project with the same name already exists");
        }
        return super.validate(value);
    }
}

