/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.webhooks;

import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.build.IBuildTrigger;
import com.openshift.restclient.model.build.IWebhookTrigger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WebhookUtil {
    public static List<IWebhookTrigger> getWebHooks(IBuildConfig buildConfig) {
        if (buildConfig == null) {
            return null;
        }
        List triggers = buildConfig.getBuildTriggers();
        List<IWebhookTrigger> webHooks = null;
        if (triggers == null || triggers.isEmpty()) {
            webHooks = Collections.emptyList();
        } else {
            webHooks = new ArrayList<IWebhookTrigger>(triggers.size());
            for (IBuildTrigger trigger : triggers) {
                IWebhookTrigger webHook = WebhookUtil.getAsWebHook(trigger);
                if (webHook == null) continue;
                webHooks.add(webHook);
            }
        }
        return webHooks;
    }

    private static IWebhookTrigger getAsWebHook(IBuildTrigger trigger) {
        if (trigger == null) {
            return null;
        }
        switch (trigger.getType()) {
            case "github": 
            case "generic": 
            case "Generic": 
            case "GitHub": {
                return (IWebhookTrigger)trigger;
            }
        }
        return null;
    }
}

