/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.internal.ui.wizard.common.IResourceLabelsPageModel;

public class ResourceLabelsPageModel
extends ObservablePojo
implements IResourceLabelsPageModel {
    private Collection<String> readonlyLabels = Arrays.asList("template");
    private List<IResourceLabelsPageModel.Label> labels = new ArrayList<IResourceLabelsPageModel.Label>();
    private IResourceLabelsPageModel.Label selectedLabel;

    @Override
    public List<IResourceLabelsPageModel.Label> getLabels() {
        return this.labels;
    }

    @Override
    public void setLabels(List<IResourceLabelsPageModel.Label> labels) {
        this.labels = new ArrayList<IResourceLabelsPageModel.Label>(labels);
        this.firePropertyChange("labels", this.labels, this.labels);
    }

    @Override
    public Collection<String> getReadOnlyLabels() {
        return this.readonlyLabels;
    }

    @Override
    public void setSelectedLabel(IResourceLabelsPageModel.Label label) {
        this.selectedLabel = label;
        this.firePropertyChange("selectedLabel", this.selectedLabel, this.selectedLabel);
    }

    @Override
    public IResourceLabelsPageModel.Label getSelectedLabel() {
        return this.selectedLabel;
    }

    @Override
    public void removeLabel(IResourceLabelsPageModel.Label label) {
        ArrayList<IResourceLabelsPageModel.Label> old = new ArrayList<IResourceLabelsPageModel.Label>(this.labels);
        int index = this.labels.indexOf(label);
        if (index > -1) {
            this.labels.remove(label);
            this.fireIndexedPropertyChange("labels", index, old, Collections.unmodifiableList(this.labels));
        }
    }

    @Override
    public void updateLabel(IResourceLabelsPageModel.Label label, String key, String value) {
        ArrayList<IResourceLabelsPageModel.Label> old = new ArrayList<IResourceLabelsPageModel.Label>(this.labels);
        int index = this.labels.indexOf(label);
        if (index > -1) {
            this.labels.set(index, new IResourceLabelsPageModel.Label(key, value));
            this.fireIndexedPropertyChange("labels", index, old, Collections.unmodifiableList(this.labels));
        }
    }

    @Override
    public void addLabel(String key, String value) {
        ArrayList<IResourceLabelsPageModel.Label> old = new ArrayList<IResourceLabelsPageModel.Label>(this.labels);
        this.labels.add(new IResourceLabelsPageModel.Label(key, value));
        this.fireIndexedPropertyChange("labels", this.labels.size(), old, Collections.unmodifiableList(this.labels));
    }

    public void dispose() {
        super.dispose();
        this.labels.clear();
        this.selectedLabel = null;
    }
}

