/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.connection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionFactory;
import org.jboss.tools.openshift.internal.common.ui.connection.BaseConnectionEditor;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardPageModel;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNullValidator;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.detailviews.AbstractStackedDetailViews;
import org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils;
import org.jboss.tools.openshift.internal.ui.wizard.connection.BasicAuthenticationDetailView;
import org.jboss.tools.openshift.internal.ui.wizard.connection.IConnectionEditorDetailView;
import org.jboss.tools.openshift.internal.ui.wizard.connection.OAuthDetailView;

public class ConnectionEditor
extends BaseConnectionEditor {
    private static final String PROPERTY_SELECTED_DETAIL_VIEW = "selectedDetailView";
    private Map<String, IConnectionEditorDetailView> detailViews = new HashMap<String, IConnectionEditorDetailView>();
    private ConnectionEditorStackedDetailViews stackedViews;
    private DetailViewModel detailViewModel = new DetailViewModel();
    private ComboViewer authTypeViewer;
    private IObservableValue<Boolean> rememberTokenObservable;
    private IObservableValue<AbstractStackedDetailViews.IDetailView> selectedDetailViewObservable;
    private IObservableValue<String> authSchemeObservable;
    private Binding selectedAuthTypeBinding;

    public Composite createControls(Composite parent, ConnectionWizardPageModel pageModel, DataBindingContext dbc) {
        Composite composite = this.setControl(new Composite(parent, 0));
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).spacing(10, 10).applyTo(composite);
        this.selectedDetailViewObservable = BeanProperties.value((String)PROPERTY_SELECTED_DETAIL_VIEW, IConnectionEditorDetailView.class).observe((Object)this.detailViewModel);
        this.authSchemeObservable = BeanProperties.value((String)"authScheme", String.class).observe((Object)this.detailViewModel);
        OAuthDetailView oAuthDetailView = new OAuthDetailView(this.wizardPage.getWizard(), pageModel, this.changeListener, pageModel.getContext(), this.authSchemeObservable);
        this.detailViews.put("OAuth", oAuthDetailView);
        this.detailViews.put("Basic", new BasicAuthenticationDetailView(pageModel, this.changeListener, pageModel.getContext()));
        this.rememberTokenObservable = oAuthDetailView.getRememberTokenObservable();
        Label authTypeLabel = new Label(composite, 0);
        authTypeLabel.setText("Protocol:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)authTypeLabel);
        Combo authTypeCombo = new Combo(composite, 2056);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)authTypeCombo);
        this.authTypeViewer = new ComboViewer(authTypeCombo);
        this.authTypeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.authTypeViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }
        });
        this.authTypeViewer.setInput(this.detailViews.values());
        Composite detailsContainer = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(3, 1).applyTo((Control)detailsContainer);
        this.stackedViews = new ConnectionEditorStackedDetailViews(this.selectedDetailViewObservable, pageModel, detailsContainer, dbc);
        this.stackedViews.createControls(false);
        return composite;
    }

    public void onVisible(IObservableValue detailViewModelObservable, ConnectionWizardPageModel pageModel, DataBindingContext dbc) {
        this.bindWidgetsToInternalModel(dbc);
        this.detailViewModel.setSelectedConnection(pageModel.getSelectedConnection());
    }

    public void onInVisible(IObservableValue detailViewModelObservable, DataBindingContext dbc) {
        this.detailViewModel.getSelectedDetailView().onInVisible(detailViewModelObservable, dbc);
        this.disposeBindings();
    }

    private void bindWidgetsToInternalModel(DataBindingContext dbc) {
        this.selectedAuthTypeBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.authTypeViewer)).validatingAfterGet((IValidator)new IsNotNullValidator(ValidationStatus.cancel((String)"Please select an authorization protocol.")))).to(this.selectedDetailViewObservable).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)this.selectedAuthTypeBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
    }

    public void onInVisible(IObservableValue detailsViewModelObservable, ConnectionWizardPageModel pageModel, DataBindingContext dbc) {
        this.detailViewModel.getSelectedDetailView().onInVisible(detailsViewModelObservable, dbc);
        this.disposeBindings();
    }

    private void disposeBindings() {
        DataBindingUtils.dispose((ValidationStatusProvider)this.selectedAuthTypeBinding);
        AbstractStackedDetailViews.IDetailView[] iDetailViewArray = this.stackedViews.getDetailViews();
        int n = iDetailViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractStackedDetailViews.IDetailView view = iDetailViewArray[n2];
            view.dispose();
            ++n2;
        }
    }

    protected void onSelectedConnectionChanged(IObservableValue selectedConnection) {
        IConnection conn = (IConnection)selectedConnection.getValue();
        this.detailViewModel.setSelectedConnection(conn);
    }

    public boolean isViewFor(Object object) {
        return object instanceof ConnectionFactory;
    }

    private IConnectionEditorDetailView getDetailView() {
        return this.detailViewModel.getSelectedDetailView();
    }

    protected ConnectionWizardPageModel.IConnectionAuthenticationProvider createConnectionAuthenticationProvider(ConnectionWizardPageModel pageModel) {
        return new ConnectionAuthenticationProviderProxy();
    }

    private class ConnectionAuthenticationProviderProxy
    implements ConnectionWizardPageModel.IConnectionAuthenticationProvider {
        private ConnectionAuthenticationProviderProxy() {
        }

        public IConnection update(IConnection connection) {
            return ConnectionEditor.this.getDetailView().getConnectionAuthenticationProvider().update(connection);
        }
    }

    private class ConnectionEditorStackedDetailViews
    extends AbstractStackedDetailViews {
        public ConnectionEditorStackedDetailViews(IObservableValue<AbstractStackedDetailViews.IDetailView> detailViewModel, Object context, Composite parent, DataBindingContext dbc) {
            super(detailViewModel, context, parent, dbc);
        }

        protected AbstractStackedDetailViews.IDetailView[] getDetailViews() {
            return ConnectionEditor.this.detailViews.values().toArray(new IConnectionEditorDetailView[ConnectionEditor.this.detailViews.size()]);
        }
    }

    private class DetailViewModel
    extends ObservablePojo {
        private IConnectionEditorDetailView selectedDetailView;

        private DetailViewModel() {
        }

        public IConnectionEditorDetailView getSelectedDetailView() {
            return this.selectedDetailView;
        }

        public void setSelectedDetailView(IConnectionEditorDetailView view) {
            this.selectedDetailView = view;
        }

        public void setSelectedConnection(IConnection conn) {
            if (conn instanceof Connection) {
                Connection connection = (Connection)conn;
                ConnectionEditor.this.selectedDetailViewObservable.setValue((Object)((AbstractStackedDetailViews.IDetailView)ConnectionEditor.this.detailViews.get(connection.getAuthScheme())));
            } else {
                ConnectionEditor.this.rememberTokenObservable.setValue((Object)Boolean.FALSE);
                ConnectionEditor.this.selectedDetailViewObservable.setValue((Object)((AbstractStackedDetailViews.IDetailView)ConnectionEditor.this.detailViews.get("OAuth")));
            }
            this.setDetailViewsConnection(conn);
        }

        private void setDetailViewsConnection(IConnection conn) {
            for (IConnectionEditorDetailView view : ConnectionEditor.this.detailViews.values()) {
                view.setSelectedConnection(conn);
            }
        }
    }
}

