/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.connection;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.jboss.tools.openshift.common.core.connection.HumanReadableX509Certificate;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class SSLCertificateUIHelper {
    public static final SSLCertificateUIHelper INSTANCE = new SSLCertificateUIHelper();

    private SSLCertificateUIHelper() {
    }

    public void setTextAndStyle(X509Certificate certificate, StyledText styledText) {
        if (certificate == null) {
            return;
        }
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        StringBuilder builder = new StringBuilder();
        this.createTextAndStyle(certificate, builder, styles);
        styledText.setText(builder.toString());
        this.setStyleRanges(styledText, styles);
    }

    public void clean(StyledText styledText) {
        this.setStyleRanges(styledText, new ArrayList<StyleRange>());
        styledText.setText("");
    }

    public void createTextAndStyle(X509Certificate certificate, StringBuilder builder, List<StyleRange> styles) {
        if (certificate == null) {
            return;
        }
        HumanReadableX509Certificate cert = new HumanReadableX509Certificate(certificate);
        this.appendLabel(String.valueOf(cert.getIssuedTo("CN")) + "\n\n", builder, styles);
        this.appendLabeledValue("Issued To:\n", cert.getIssuedTo(), builder, styles);
        this.appendLabeledValue("\nIssued By:\n", cert.getIssuedBy(), builder, styles);
        this.appendLabeledValue("\nValidity:\n", cert.getValidity(), builder, styles);
        this.appendLabeledValue("\nSHA1 Fingerprint:\n", cert.getFingerprint(), builder, styles);
    }

    private void appendLabeledValue(String label, String value, StringBuilder builder, List<StyleRange> styles) {
        this.appendLabel(label, builder, styles);
        this.appendValue(value, builder);
    }

    private void appendValue(String value, StringBuilder builder) {
        builder.append(value).append(StringUtils.getLineSeparator());
    }

    private void appendLabel(String label, StringBuilder builder, List<StyleRange> styles) {
        StyleRange styleRange = this.startBoldStyleRange(builder);
        builder.append(label);
        this.finishBoldStyleRange(builder, styleRange);
        styles.add(styleRange);
    }

    private StyleRange startBoldStyleRange(StringBuilder builder) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = builder.length();
        styleRange.fontStyle = 1;
        return styleRange;
    }

    private StyleRange finishBoldStyleRange(StringBuilder builder, StyleRange styleRange) {
        styleRange.length = builder.length() - styleRange.start;
        return styleRange;
    }

    private void setStyleRanges(StyledText logText, List<StyleRange> styles) {
        for (StyleRange style : styles) {
            logText.setStyleRange(style);
        }
    }
}

