/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.OkCancelButtonWizardDialog;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.ListDockerImagesWizardModel;

public class ListDockerImagesWizardPage
extends AbstractOpenShiftWizardPage {
    private final ListDockerImagesWizardModel model;
    private static String LIST_DOCKER_IMAGES_PAGE_NAME = "List Docker Images Page";
    private static final String PAGE_DESCRIPTION = "This page allows you to choose a local image and the name to be used for the deployed resources.";

    public ListDockerImagesWizardPage(IWizard wizard, ListDockerImagesWizardModel model) {
        super("Deploy an Image", PAGE_DESCRIPTION, LIST_DOCKER_IMAGES_PAGE_NAME, wizard);
        this.model = model;
    }

    public boolean isPageComplete() {
        return this.model.getSelectedDockerImage() != null;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).numColumns(2).applyTo(parent);
        Label filterByNameLabel = new Label(parent, 128);
        filterByNameLabel.setText("Filter:");
        filterByNameLabel.setToolTipText("Filter images by their name");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)filterByNameLabel);
        final Text filterByNameText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)filterByNameText);
        Table dockerImagesTable = new Table(parent, 68352);
        TableViewer dockerImagesTableViewer = new TableViewer(dockerImagesTable);
        dockerImagesTable.setHeaderVisible(true);
        dockerImagesTable.setLinesVisible(true);
        ListDockerImagesWizardPage.addTableViewerColum(dockerImagesTableViewer, "Name", 0, 16384, 200, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ListDockerImagesWizardModel.DockerImageTag)element).getRepoName();
            }
        });
        ListDockerImagesWizardPage.addTableViewerColum(dockerImagesTableViewer, "Tag", 0, 16384, 100, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ListDockerImagesWizardModel.DockerImageTag)element).getTag();
            }
        });
        ListDockerImagesWizardPage.addTableViewerColum(dockerImagesTableViewer, "Image ID", 0, 16384, 150, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ListDockerImagesWizardModel.DockerImageTag)element).getId();
            }
        });
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).hint(200, 100).applyTo((Control)dockerImagesTable);
        dockerImagesTableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        dockerImagesTableViewer.setInput((Object)BeanProperties.list(ListDockerImagesWizardModel.class, (String)"dockerImages").observe((Object)this.model));
        ViewerFilter imageNameFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ((ListDockerImagesWizardModel.DockerImageTag)element).getRepoName().contains(filterByNameText.getText());
            }
        };
        dockerImagesTableViewer.addFilter(imageNameFilter);
        filterByNameText.addModifyListener(ListDockerImagesWizardPage.onFilterImages(dockerImagesTableViewer));
        dbc.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)dockerImagesTableViewer), BeanProperties.value((String)"selectedDockerImage").observe((Object)this.model));
        dockerImagesTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IWizardContainer container = ListDockerImagesWizardPage.this.getWizard().getContainer();
                if (container instanceof OkCancelButtonWizardDialog) {
                    ((OkCancelButtonWizardDialog)container).autoFinish();
                }
            }
        });
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ListDockerImagesWizardPage.this.model.setDockerImages(ListDockerImagesWizardPage.this.model.getDockerConnection().getImages(true));
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private static ModifyListener onFilterImages(final TableViewer dockerImagesTableViewer) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                dockerImagesTableViewer.refresh();
            }
        };
    }

    private static TableViewerColumn addTableViewerColum(TableViewer tableViewer, String title, int style, int alignment, int width, CellLabelProvider columnLabelProvider) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, style);
        TableColumn column = viewerColumn.getColumn();
        if (title != null) {
            column.setText(title);
        }
        column.setAlignment(alignment);
        column.setWidth(width);
        viewerColumn.setLabelProvider(columnLabelProvider);
        return viewerColumn;
    }

    static class ImageIDColumnLabelProvider
    extends ColumnLabelProvider {
        ImageIDColumnLabelProvider() {
        }

        public String getText(Object element) {
            return ((ListDockerImagesWizardModel.DockerImageTag)element).getId();
        }
    }

    static class ImageNameColumnLabelProvider
    extends ColumnLabelProvider {
        ImageNameColumnLabelProvider() {
        }

        public String getText(Object element) {
            return ((ListDockerImagesWizardModel.DockerImageTag)element).getRepoName();
        }
    }
}

