/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.importapp;

import com.openshift.restclient.OpenShiftException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.osgi.util.NLS;
import org.jboss.ide.eclipse.as.core.util.RegExUtils;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.egit.ui.util.EGitUIUtils;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.GeneralProjectImportOperation;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.MavenProjectImportOperation;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.WontOverwriteException;

public class ImportProjectOperation {
    private static final String PLATFORM_SEPARATOR = Matcher.quoteReplacement(File.separator);
    private File cloneDestination;
    private String gitUrl;
    private String gitRef;
    private Collection<String> filters;
    private boolean reuseGitRepo;
    private boolean checkoutBranch;

    public ImportProjectOperation(String gitUrl, String gitRef, File cloneDestination, Collection<String> filters, boolean checkoutBranch) {
        this(gitUrl, gitRef, cloneDestination, filters, checkoutBranch, true);
    }

    public ImportProjectOperation(String gitUrl, String gitRef, File cloneDestination, Collection<String> filters) {
        this(gitUrl, gitRef, cloneDestination, filters, true, false);
    }

    protected ImportProjectOperation(String gitUrl, String gitRef, File cloneDestination, Collection<String> filters, boolean checkoutBranch, boolean reuseGitRepo) {
        this.gitUrl = gitUrl;
        this.gitRef = gitRef;
        this.cloneDestination = cloneDestination;
        this.filters = ImportProjectOperation.sanitize(filters);
        this.reuseGitRepo = reuseGitRepo;
        this.checkoutBranch = checkoutBranch;
    }

    public List<IProject> execute(IProgressMonitor monitor) throws OpenShiftException, CoreException, InterruptedException, URISyntaxException, InvocationTargetException, IOException, NoWorkTreeException, GitAPIException {
        if (!this.reuseGitRepo) {
            return this.importCloning(this.gitUrl, this.gitRef, this.cloneDestination, this.filters, monitor);
        }
        return this.importReusingExistingRepo(this.gitUrl, this.gitRef, this.cloneDestination, this.filters, this.checkoutBranch, monitor);
    }

    private List<IProject> importCloning(String gitUrl, String gitRef, File cloneDestination, Collection<String> filters, IProgressMonitor monitor) throws CoreException, OpenShiftException, InvocationTargetException, InterruptedException, URISyntaxException {
        if (this.cloneDestinationExists()) {
            throw new WontOverwriteException(NLS.bind((String)"There's already a folder at {0}. The new OpenShift project would overwrite it. Please choose another destination to clone to.", (Object)this.getCloneDestination().getAbsolutePath()), new Object[0]);
        }
        File repositoryFolder = this.cloneRepository(gitUrl, cloneDestination, gitRef, monitor);
        List<IProject> importedProjects = this.importProjectsFrom(repositoryFolder, filters, monitor);
        this.connectToGitRepo(importedProjects, repositoryFolder, monitor);
        return importedProjects;
    }

    private List<IProject> importReusingExistingRepo(String gitUrl, String gitRef, File repositoryFolder, Collection<String> filters, boolean checkoutBranch, IProgressMonitor monitor) throws CoreException, InterruptedException {
        List<IProject> importedProjects = this.importProjectsFrom(repositoryFolder, filters, monitor);
        this.connectToGitRepo(importedProjects, repositoryFolder, monitor);
        if (checkoutBranch) {
            this.checkoutBranch(gitRef, gitUrl, importedProjects, repositoryFolder, monitor);
        }
        return importedProjects;
    }

    protected void checkoutBranch(String gitRef, String gitUrl, List<IProject> importedProjects, File repositoryFolder, IProgressMonitor monitor) throws CoreException {
        if (!StringUtils.isEmpty((String)gitRef) && !CollectionUtils.isEmpty(importedProjects)) {
            IProject project = importedProjects.get(0);
            Repository repository = EGitUtils.getRepository((IProject)project);
            try {
                if (!EGitUtils.hasBranch((String)gitRef, (Repository)repository)) {
                    Pattern gitURIPattern = Pattern.compile(RegExUtils.escapeRegex((String)gitUrl));
                    RemoteConfig remote = EGitUtils.getRemoteByUrl((Pattern)gitURIPattern, (Repository)repository);
                    this.fetchBranch(gitRef, remote, repository, monitor);
                }
                CheckoutResult result = EGitUtils.checkoutBranch((String)gitRef, (Repository)repository, (IProgressMonitor)monitor);
                switch (result.getStatus()) {
                    case CONFLICTS: 
                    case ERROR: {
                        throw new CoreException(StatusFactory.errorStatus((String)"org.jboss.tools.openshift.core", (String)NLS.bind((String)"Could not check out the branch {0} of the (reused) local repository at\u00a0{1} because of {2}. Please resolve the problem and check out the branch manually so that it matches the code that's used in your OpenShift application.", (Object[])new Object[]{gitRef, repositoryFolder, result.getStatus().toString().toLowerCase()})));
                    }
                }
            }
            catch (IOException e) {
                throw new CoreException(StatusFactory.errorStatus((String)"org.jboss.tools.openshift.core", (String)NLS.bind((String)"Could check that branch {0} exists within the (reused) local repository at\u00a0{1}.", (Object)gitRef, (Object)repositoryFolder), (Throwable)e));
            }
            catch (InvocationTargetException e) {
                throw new CoreException(StatusFactory.errorStatus((String)"org.jboss.tools.openshift.core", (String)NLS.bind((String)"Could not fetch branch {0} from check that branch {0} exists within the (reused) local repository at\u00a0{1}.", (Object)gitRef, (Object)repositoryFolder), (Throwable)e));
            }
        }
    }

    private void fetchBranch(String gitRef, RemoteConfig remote, Repository repository, IProgressMonitor monitor) throws CoreException, InvocationTargetException, IOException {
        if (remote == null) {
            throw new CoreException(StatusFactory.errorStatus((String)"org.jboss.tools.openshift.ui", (String)NLS.bind((String)"Could not fetch determine the remote for the repo at {0} that we should fetch branch {1} from.", (Object)repository.getDirectory(), (Object)gitRef)));
        }
        EGitUtils.fetch((RemoteConfig)remote, Arrays.asList(new RefSpec("refs/heads/" + gitRef + ":" + "refs/remotes/" + remote.getName() + "/" + gitRef)), (Repository)repository, (IProgressMonitor)monitor);
        RevCommit commit = EGitUtils.getLatestCommit((String)gitRef, (String)remote.getName(), (Repository)repository);
        EGitUtils.createBranch((String)gitRef, (RevCommit)commit, (Repository)repository, (IProgressMonitor)monitor);
    }

    private List<IProject> importProjectsFrom(File folder, Collection<String> filters, IProgressMonitor monitor) throws CoreException, InterruptedException {
        MavenProjectImportOperation mavenImport = new MavenProjectImportOperation(folder);
        mavenImport.setFilters(filters);
        List importedProjects = mavenImport.isMavenProject() ? mavenImport.importToWorkspace(monitor) : new GeneralProjectImportOperation(folder).importToWorkspace(monitor);
        return importedProjects;
    }

    protected void connectToGitRepo(List<IProject> projects, File projectFolder, IProgressMonitor monitor) throws CoreException {
        for (IProject project : projects) {
            if (project == null) continue;
            EGitUtils.connect((IProject)project, (IProgressMonitor)monitor);
        }
    }

    protected File cloneRepository(String gitUrl, File destination, String gitRef, IProgressMonitor monitor) throws OpenShiftException, InvocationTargetException, InterruptedException, URISyntaxException {
        monitor.subTask(NLS.bind((String)"Cloning  {0}...", (Object)gitUrl));
        EGitUIUtils.ensureEgitUIIsStarted();
        EGitUtils.cloneRepository((String)gitUrl, (String)"origin", (String)gitRef, (File)destination, (CloneOperation.PostCloneTask)EGitUIUtils.ADD_TO_REPOVIEW_TASK, (IProgressMonitor)monitor);
        return destination;
    }

    protected File getCloneDestination() {
        return this.cloneDestination;
    }

    protected boolean cloneDestinationExists() {
        return this.cloneDestination != null && this.cloneDestination.exists();
    }

    private static Collection<String> sanitize(Collection<String> filters) {
        LinkedHashSet<String> sanitized = null;
        if (filters != null) {
            sanitized = new LinkedHashSet<String>(filters.size());
            for (String path : filters) {
                if (!StringUtils.isNotBlank((String)path)) continue;
                sanitized.add(ImportProjectOperation.makePlatformDependent(path));
            }
        }
        return sanitized;
    }

    private static String makePlatformDependent(String path) {
        return path.replaceAll("/", PLATFORM_SEPARATOR).replaceAll("\\\\", PLATFORM_SEPARATOR);
    }
}

