/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;

public class EditValueDialog
extends InputDialog {
    static final String PROVIDE_REQUIRED_VALUE = "{0} is a required value, please provide a value.";
    static final String PROVIDE_NEW_VALUE = "Please provide new value";
    DataBindingContext dbc = new DataBindingContext();
    InputModel model;
    String name;
    String initialValue;
    boolean required;
    private IValidator valueValidator;

    public EditValueDialog(Shell shell, String title, String message, String name, String initialValue, boolean required) {
        super(shell, title, message, initialValue, (IInputValidator)new InputValidator());
        this.name = name;
        this.initialValue = initialValue;
        this.required = required;
        this.model = new InputModel();
    }

    public void setValueValidator(IValidator valueValidator) {
        this.valueValidator = valueValidator;
    }

    public InputValidator getValidator() {
        return (InputValidator)super.getValidator();
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        Text text = this.getTextControl(control);
        if (text != null) {
            IObservableValue modelObservable = BeanProperties.value((String)"value").observe((Object)this.model);
            ISWTObservableValue textObservable = WidgetProperties.text((int)24).observe((Widget)text);
            ValueBindingBuilder.bind((IObservableValue)textObservable).to(modelObservable).in(this.dbc);
            ValidationStatusProvider validator = new ValidationStatusProvider((IObservableValue)textObservable);
            this.getValidator().setProvider(validator);
            this.dbc.addValidationStatusProvider((org.eclipse.core.databinding.ValidationStatusProvider)validator);
            ControlDecorationSupport.create((org.eclipse.core.databinding.ValidationStatusProvider)validator, (int)16512);
        } else {
            OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)new NullPointerException("Cannot find text widget."));
        }
        return control;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setErrorMessage(this.getValidator().isValid(this.initialValue));
        return control;
    }

    private Text getTextControl(Composite control) {
        Text text = null;
        Control[] controlArray = control.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Text) {
                text = (Text)c;
                break;
            }
            ++n2;
        }
        return text;
    }

    public static class InputModel
    extends ObservableUIPojo {
        static final String VALUE = "value";
        String value = "";

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    static class InputValidator
    implements IInputValidator {
        ValidationStatusProvider provider;

        InputValidator() {
        }

        public String isValid(String newText) {
            IStatus status;
            if (this.provider != null && !(status = this.provider.validate()).isOK()) {
                return status.getMessage();
            }
            return null;
        }

        public void setProvider(ValidationStatusProvider provider) {
            this.provider = provider;
        }
    }

    class ValidationStatusProvider
    extends MultiValidator {
        IObservableValue textObservable;

        ValidationStatusProvider(IObservableValue textObservable) {
            this.textObservable = textObservable;
        }

        protected IStatus validate() {
            String text = (String)this.textObservable.getValue();
            boolean isTextEmpty = StringUtils.isEmpty((String)text);
            if (EditValueDialog.this.required && isTextEmpty) {
                return ValidationStatus.error((String)NLS.bind((String)EditValueDialog.PROVIDE_REQUIRED_VALUE, (Object)EditValueDialog.this.name));
            }
            boolean isInitEmpty = StringUtils.isEmpty((String)EditValueDialog.this.initialValue);
            if (isTextEmpty == isInitEmpty && (isTextEmpty || text.equals(EditValueDialog.this.initialValue))) {
                return ValidationStatus.cancel((String)EditValueDialog.PROVIDE_NEW_VALUE);
            }
            if (EditValueDialog.this.valueValidator != null) {
                return EditValueDialog.this.valueValidator.validate((Object)text);
            }
            return ValidationStatus.ok();
        }
    }
}

