/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.route.IRoute;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.tools.common.ui.JobUtils;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.core.util.OpenShiftResourceUniqueId;
import org.jboss.tools.openshift.internal.common.core.UsageStats;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.OpenShiftUIUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.IConnectionAwareWizard;
import org.jboss.tools.openshift.internal.core.preferences.OCBinary;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.job.IResourcesModelJob;
import org.jboss.tools.openshift.internal.ui.job.RefreshResourcesJob;
import org.jboss.tools.openshift.internal.ui.server.ServerSettingsWizardPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.common.ResourceLabelsPage;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.DeploymentConfigPage;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.ServicesAndRoutingPage;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.ImportApplicationWizard;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ApplicationSourceListPage;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.NewApplicationWizardModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromimage.ApplicationSourceFromImageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromimage.BuildConfigPage;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate.ApplicationSourceFromTemplateModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate.TemplateParametersPage;

public class NewApplicationWizard
extends Wizard
implements IWorkbenchWizard,
IConnectionAwareWizard<Connection> {
    private NewApplicationWizardModel model = new NewApplicationWizardModel();
    private ApplicationSourceFromTemplateModel fromTemplateModel = new ApplicationSourceFromTemplateModel();
    private ApplicationSourceFromImageModel fromImageModel = new ApplicationSourceFromImageModel();

    public NewApplicationWizard() {
        this.setWindowTitle("New OpenShift Application");
        this.setNeedsProgressMonitor(true);
        Stream.of(this.fromTemplateModel, this.fromImageModel).forEach(m -> {
            this.model.addPropertyChangeListener("selectedAppSource", (PropertyChangeListener)((Object)m));
            this.model.addPropertyChangeListener("eclipseProject", (PropertyChangeListener)((Object)m));
            this.model.addPropertyChangeListener("project", (PropertyChangeListener)((Object)m));
            this.model.addPropertyChangeListener("labels", (PropertyChangeListener)((Object)m));
        });
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fromImageModel.setContainer(this.getContainer());
        if (selection == null || selection.isEmpty()) {
            return;
        }
        IProject selectedProject = (IProject)UIUtils.getFirstElement((ISelection)selection, IProject.class);
        this.model.setEclipseProject(selectedProject);
        Connection connection = (Connection)UIUtils.getFirstElement((ISelection)selection, Connection.class);
        if (connection != null) {
            this.setConnection(connection);
        } else {
            IResource resource = (IResource)UIUtils.getFirstElement((ISelection)selection, IResource.class);
            if (resource != null) {
                connection = ConnectionsRegistryUtil.safeGetConnectionFor((IResource)resource);
                this.setConnection(connection);
                this.model.setProject(resource.getProject());
            }
        }
        if (connection != null) {
            ConnectionsRegistrySingleton.getInstance().setRecent((IConnection)connection);
        }
    }

    public void addPages() {
        BuildConfigPage bcPage = new BuildConfigPage((IWizard)this, this.fromImageModel){

            public boolean isPageComplete() {
                return NewApplicationWizard.this.isTemplateFlow() ? true : super.isPageComplete();
            }
        };
        DeploymentConfigPage dcPage = new DeploymentConfigPage((IWizard)this, this.fromImageModel){

            public boolean isPageComplete() {
                return NewApplicationWizard.this.isTemplateFlow() ? true : super.isPageComplete();
            }
        };
        ServicesAndRoutingPage servicesPage = new ServicesAndRoutingPage((IWizard)this, this.fromImageModel){

            public boolean isPageComplete() {
                return NewApplicationWizard.this.isTemplateFlow() ? true : super.isPageComplete();
            }
        };
        TemplateParametersPage paramPage = new TemplateParametersPage((IWizard)this, this.fromTemplateModel){

            public boolean isPageComplete() {
                return NewApplicationWizard.this.isTemplateFlow() ? this.getContainer() != null && !(this.getContainer().getCurrentPage() instanceof ApplicationSourceListPage) && super.isPageComplete() : true;
            }

            public IWizardPage getNextPage() {
                return NewApplicationWizard.this.getPage("Resource Labels Page");
            }
        };
        ResourceLabelsPage labelsPage = new ResourceLabelsPage((IWizard)this, this.model);
        ApplicationSourceListPage listPage = new ApplicationSourceListPage((IWizard)this, this.model){

            public IWizardPage getNextPage() {
                if (NewApplicationWizard.this.isTemplateFlow()) {
                    return NewApplicationWizard.this.getPage("Template Parameter Page");
                }
                return NewApplicationWizard.this.getPage("Build Config Settings Page");
            }
        };
        this.addPage((IWizardPage)listPage);
        this.addPage((IWizardPage)paramPage);
        this.addPage((IWizardPage)bcPage);
        this.addPage((IWizardPage)dcPage);
        this.addPage((IWizardPage)servicesPage);
        this.addPage((IWizardPage)labelsPage);
    }

    public void dispose() {
        super.dispose();
        this.model.dispose();
        this.fromImageModel.dispose();
        this.fromTemplateModel.dispose();
        this.model = null;
        this.fromImageModel = null;
        this.fromTemplateModel = null;
    }

    private boolean isTemplateFlow() {
        if (this.model.getSelectedAppSource() != null && this.model.getSelectedAppSource().getSource() != null) {
            return "Template".equals(this.model.getSelectedAppSource().getSource().getKind());
        }
        return true;
    }

    public boolean performFinish() {
        final IResourcesModelJob createJob = this.isTemplateFlow() ? this.fromTemplateModel.createFinishJob() : this.fromImageModel.createFinishJob();
        createJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus status = event.getResult();
                if (JobUtils.isOk((IStatus)status) || JobUtils.isWarning((IStatus)status)) {
                    Display.getDefault().syncExec(createJob.getSummaryRunnable(NewApplicationWizard.this.getShell()));
                    OpenShiftUIUtils.showOpenShiftExplorer();
                    if (NewApplicationWizard.this.model.getEclipseProject() != null) {
                        return;
                    }
                    final Collection<IResource> resources = createJob.getResources();
                    final Map<com.openshift.restclient.model.IProject, Collection<IBuildConfig>> projectsAndBuildConfigs = this.getBuildConfigs(resources);
                    if (projectsAndBuildConfigs.isEmpty()) {
                        return;
                    }
                    final Connection connection = NewApplicationWizard.this.model.getConnection();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            final ImportApplicationWizard wizard = new ImportApplicationWizard(projectsAndBuildConfigs);
                            wizard.addImportJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                                public void done(IJobChangeEvent event) {
                                    final IService service = this.getService(resources);
                                    final List<IProject> importedProjects = wizard.getImportJob().getImportedProjects();
                                    if (service != null && importedProjects.size() == 1) {
                                        Display.getDefault().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                if (MessageDialog.openQuestion((Shell)NewApplicationWizard.this.getShell(), (String)"Create server adapter", (String)NLS.bind((String)"Would you like to create a server adapter for the imported {0} project?", (Object)((IProject)importedProjects.get(0)).getName()))) {
                                                    this.createServerAdapter((IProject)importedProjects.get(0), connection, service, this.getRoute(resources));
                                                }
                                            }
                                        });
                                    }
                                }
                            });
                            new WizardDialog(NewApplicationWizard.this.getShell(), (IWizard)wizard).open();
                        }
                    });
                }
            }

            protected Map<com.openshift.restclient.model.IProject, Collection<IBuildConfig>> getBuildConfigs(Collection<IResource> resources) {
                LinkedHashMap<com.openshift.restclient.model.IProject, Collection<IBuildConfig>> projects = new LinkedHashMap<com.openshift.restclient.model.IProject, Collection<IBuildConfig>>();
                for (IResource resource : resources) {
                    IBuildConfig buildConfig;
                    if (!(resource instanceof IBuildConfig) || !StringUtils.isNotBlank((String)(buildConfig = (IBuildConfig)resource).getSourceURI())) continue;
                    com.openshift.restclient.model.IProject p = buildConfig.getProject();
                    LinkedHashSet<IBuildConfig> buildConfigs = (LinkedHashSet<IBuildConfig>)projects.get(p);
                    if (buildConfigs == null) {
                        buildConfigs = new LinkedHashSet<IBuildConfig>();
                        projects.put(p, buildConfigs);
                    }
                    buildConfigs.add(buildConfig);
                }
                return projects;
            }

            protected IService getService(Collection<IResource> resources) {
                IResource service = this.getResourceOfType(resources, IService.class);
                return service == null ? null : (IService)service;
            }

            protected IRoute getRoute(Collection<IResource> resources) {
                IResource route = this.getResourceOfType(resources, IRoute.class);
                return route == null ? null : (IRoute)route;
            }

            private IResource getResourceOfType(Collection<IResource> resources, Class<? extends IResource> type) {
                for (IResource resource : resources) {
                    if (!type.isInstance(resource)) continue;
                    return resource;
                }
                return null;
            }

            protected void createServerAdapter(IProject project, Connection connection, IService service, IRoute route) {
                try {
                    IServerWorkingCopy server = OpenShiftServerUtils.create((String)OpenShiftResourceUniqueId.get((IResource)service));
                    ServerSettingsWizardPageModel serverModel = new ServerSettingsWizardPageModel((IResource)service, route, project, connection, server, OCBinary.getInstance().getStatus((IConnection)connection, (IProgressMonitor)new NullProgressMonitor()));
                    serverModel.loadResources();
                    serverModel.updateServer();
                    server.setAttribute("org.jboss.tools.openshift.SERVER_START_ON_CREATION", false);
                    serverModel.saveServer(null);
                }
                catch (CoreException ce) {
                    OpenShiftUIActivator.getDefault().getLogger().logError("Error occured while creating a server adapter", (Throwable)ce);
                    return;
                }
            }
        });
        boolean success = false;
        try {
            try {
                Job job = new JobChainBuilder(createJob.getJob()).runWhenSuccessfullyDone((Job)new RefreshResourcesJob(createJob, true)).build();
                IStatus status = WizardUtils.runInWizard((Job)job, (DelegatingProgressMonitor)createJob.getDelegatingProgressMonitor(), (IWizardContainer)this.getContainer());
                success = this.isFailed(status);
            }
            catch (InterruptedException | InvocationTargetException e) {
                OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)e);
                success = false;
                UsageStats.getInstance().newV3Application(this.model.getConnection().getHost(), success);
            }
        }
        finally {
            UsageStats.getInstance().newV3Application(this.model.getConnection().getHost(), success);
        }
        return success;
    }

    private boolean isFailed(IStatus status) {
        return JobUtils.isOk((IStatus)status) || JobUtils.isWarning((IStatus)status);
    }

    public Connection getConnection() {
        return this.model.getConnection();
    }

    public boolean hasConnection() {
        return this.model.hasConnection();
    }

    public void setConnection(Connection connection) {
        this.model.setConnection(connection);
        if (this.model == null || this.fromImageModel == null) {
            return;
        }
        this.fromImageModel.setConnection(connection);
    }

    public Object getContext() {
        return null;
    }
}

