/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.resource;

import com.openshift.restclient.model.IResource;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.DelegatingProgressMonitor;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.foundation.ui.jobs.DisableAllWidgetsJob;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.ui.wizard.AbstractOpenShiftWizard;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;
import org.jboss.tools.openshift.internal.common.core.util.KeyValueFilterFactory;
import org.jboss.tools.openshift.internal.common.ui.utils.StyledTextUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.comparators.ResourceKindAndNameViewerComparator;
import org.jboss.tools.openshift.internal.ui.wizard.resource.DeleteResourcesWizardModel;
import org.jboss.tools.openshift.internal.ui.wizard.resource.ResourceLabelFilter;

public class DeleteResourcesWizard
extends AbstractOpenShiftWizard<DeleteResourcesWizardModel> {
    private Connection connection;
    private String projectName;
    private DeleteResourcesPage deleteResourcesPage;

    public DeleteResourcesWizard(Connection connection, String projectName) {
        super("Delete OpenShift Resources", (Object)new DeleteResourcesWizardModel(connection, projectName));
        this.connection = connection;
        this.projectName = projectName;
    }

    public void addPages() {
        this.deleteResourcesPage = new DeleteResourcesPage(this.connection, this.projectName, (IWizard)this);
        this.addPage((IWizardPage)this.deleteResourcesPage);
    }

    public boolean performFinish() {
        this.deleteResourcesPage.deleteResources();
        return true;
    }

    public static class DeleteResourcesPage
    extends AbstractOpenShiftWizardPage {
        private DeleteResourcesWizardModel model;

        public DeleteResourcesPage(Connection connection, String projectName, IWizard wizard) {
            super(NLS.bind((String)"Delete Resources in project {0}", (Object)projectName), "Select the resources that you want to delete from OpenShift", "deleteResources", wizard);
            this.model = new DeleteResourcesWizardModel(connection, projectName);
        }

        protected void doCreateControls(Composite parent, DataBindingContext dbc) {
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
            this.createFilterControls(parent, dbc);
            this.createResourcesControl(parent, dbc);
        }

        private void createFilterControls(Composite parent, DataBindingContext dbc) {
            Label filterLabel = new Label(parent, 0);
            filterLabel.setText("Label Filter:");
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)filterLabel);
            Text filterText = UIUtils.createSearchText((Composite)parent);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)filterText);
            Binding filterTextBinding = ((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)filterText)).converting((IConverter)new Converter(String.class, KeyValueFilterFactory.KeyValueFilter.class){

                public Object convert(Object fromObject) {
                    if (!(fromObject instanceof String)) {
                        return null;
                    }
                    try {
                        String filterText = (String)fromObject;
                        if (StringUtils.isEmpty((String)filterText)) {
                            return new KeyValueFilterFactory.KeyValueFilter();
                        }
                        List filters = KeyValueFilterFactory.create((String)filterText);
                        return filters.stream().findFirst().orElse(null);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        return null;
                    }
                }
            })).validatingAfterConvert(value -> {
                if (value == null) {
                    return ValidationStatus.error((String)"Invalid filter expression provided. Please either use plain text or conform to regular expression rules.");
                }
                return ValidationStatus.ok();
            })).to(BeanProperties.value((String)"labelFilter").observe((Object)this.model)).in(dbc);
            ControlDecorationSupport.create((ValidationStatusProvider)filterTextBinding, (int)16512, null);
            new Label(parent, 0);
            Label explanatoryLabel = new Label(parent, 64);
            explanatoryLabel.setText("You can filter resources based on their labels.\nFilter expressions take fhe form <value substring> or <key substring>=<value substring>. Key- and value-expressions can be regular expressions (ex. \".*\").");
            GridDataFactory.fillDefaults().grab(true, false).align(16384, 0x1000000).applyTo((Control)explanatoryLabel);
        }

        private void createResourcesControl(Composite parent, DataBindingContext dbc) {
            Composite resourcesContainer = new Composite(parent, 0);
            GridDataFactory.fillDefaults().span(2, -1).align(4, 4).grab(true, true).applyTo((Control)resourcesContainer);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(resourcesContainer);
            Composite tableContainer = new Composite(resourcesContainer, 0);
            IObservableValue labelFilter = BeanProperties.value((String)"labelFilter").observe((Object)this.model);
            TableViewer resourcesViewer = this.createResourcesTable((IObservableValue<KeyValueFilterFactory.KeyValueFilter>)labelFilter, tableContainer);
            GridDataFactory.fillDefaults().span(1, 3).align(4, 0x1000000).hint(-1, 500).grab(true, false).applyTo((Control)tableContainer);
            IObservableList allResourcesObservable = BeanProperties.list((String)"allResources").observe((Object)this.model);
            resourcesViewer.setInput((Object)allResourcesObservable);
            final IObservableList selectedResources = BeanProperties.list((String)"selectedResources").observe((Object)this.model);
            dbc.bindList((IObservableList)ViewerProperties.multipleSelection().observe((Viewer)resourcesViewer), selectedResources);
            dbc.addValidationStatusProvider((ValidationStatusProvider)new MultiValidator(){

                protected IStatus validate() {
                    if (selectedResources.isEmpty()) {
                        return ValidationStatus.cancel((String)"Please select the resources that should be deleted.");
                    }
                    return ValidationStatus.ok();
                }
            });
            Button selectAllButton = new Button(resourcesContainer, 8);
            selectAllButton.setText("Select All");
            GridDataFactory.fillDefaults().align(4, 0x1000000).hint(UIUtils.getDefaultButtonWidth((Button)selectAllButton), -1).applyTo((Control)selectAllButton);
            selectAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> resourcesViewer.setSelection((ISelection)new StructuredSelection(this.model.getAllResources()))));
            Button deselectAllButton = new Button(resourcesContainer, 8);
            deselectAllButton.setText("Deselect All");
            GridDataFactory.fillDefaults().align(4, 0x1000000).hint(UIUtils.getDefaultButtonWidth((Button)deselectAllButton), -1).applyTo((Control)deselectAllButton);
            deselectAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> resourcesViewer.setSelection((ISelection)new StructuredSelection())));
            GridDataFactory.fillDefaults().align(4, 4).grab(false, true).applyTo((Control)new Label(resourcesContainer, 0));
        }

        protected TableViewer createResourcesTable(IObservableValue<KeyValueFilterFactory.KeyValueFilter> labelFilter, Composite tableContainer) {
            Table table = new Table(tableContainer, 68354);
            table.setLinesVisible(true);
            table.setHeaderVisible(true);
            TableViewer resourcesViewer = new TableViewerBuilder(table, tableContainer).column(resource -> ((IResource)resource).getName()).name("Name").align(16384).weight(1).minWidth(100).buildColumn().column(resource -> ((IResource)resource).getKind()).name("Type").align(16384).weight(1).minWidth(100).buildColumn().column((CellLabelProvider)new LabelsCellLabelProvider(labelFilter)).name("Labels").align(16384).weight(2).minWidth(200).buildColumn().buildViewer();
            resourcesViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
            resourcesViewer.setComparator((ViewerComparator)new ResourceKindAndNameViewerComparator());
            resourcesViewer.setFilters(new ViewerFilter[]{new ResourceLabelFilter(labelFilter)});
            return resourcesViewer;
        }

        protected void onPageActivated(DataBindingContext dbc) {
            this.loadResources(dbc);
        }

        private void loadResources(DataBindingContext dbc) {
            final DelegatingProgressMonitor delegatingMonitor = new DelegatingProgressMonitor();
            Job job = new JobChainBuilder((Job)new DisableAllWidgetsJob(true, (Composite)this.getControl(), null)).runWhenDone(new Job("Retrieving all resources from server..."){

                protected IStatus run(IProgressMonitor monitor) {
                    delegatingMonitor.add(monitor);
                    model.loadResources((IProgressMonitor)delegatingMonitor);
                    return Status.OK_STATUS;
                }
            }).runWhenDone((Job)new DisableAllWidgetsJob(false, (Composite)this.getControl(), null)).build();
            try {
                WizardUtils.runInWizard((Job)job, (org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor)delegatingMonitor, (IWizardContainer)this.getContainer(), (DataBindingContext)dbc);
            }
            catch (InterruptedException | InvocationTargetException exception) {}
        }

        public void deleteResources() {
            this.model.deleteSelectedResources();
        }

        private static final class LabelsCellLabelProvider
        extends StyledCellLabelProvider {
            private static final String KEY_VALUE_DELIMITER = "=";
            private static final String LABELS_DELIMITER = ", ";
            private IObservableValue<KeyValueFilterFactory.KeyValueFilter> filterObservable;

            public LabelsCellLabelProvider(IObservableValue<KeyValueFilterFactory.KeyValueFilter> filter) {
                this.filterObservable = filter;
            }

            public void update(ViewerCell cell) {
                KeyValueFilterFactory.KeyValueFilter filter = (KeyValueFilterFactory.KeyValueFilter)this.filterObservable.getValue();
                IResource resource = (IResource)cell.getElement();
                Map filteredLabels = ResourceUtils.getMatchingLabels((KeyValueFilterFactory.KeyValueFilter)filter, (IResource)resource);
                this.createCellLabel(filter, filteredLabels, cell);
                ((Table)cell.getControl()).getColumn(cell.getColumnIndex()).pack();
            }

            private void createCellLabel(KeyValueFilterFactory.KeyValueFilter filter, Map<String, String> labels, ViewerCell cell) {
                ArrayList styles = new ArrayList();
                StringBuilder builder = new StringBuilder();
                labels.entrySet().forEach(entry -> {
                    if (builder.length() > 0) {
                        builder.append(LABELS_DELIMITER);
                    }
                    this.createKeyLabel(filter, styles, builder, (Map.Entry<String, String>)entry);
                    this.createValueLabel(filter, styles, builder, (Map.Entry<String, String>)entry);
                });
                cell.setText(builder.toString());
                cell.setStyleRanges(styles.toArray(new StyleRange[styles.size()]));
            }

            private void createValueLabel(KeyValueFilterFactory.KeyValueFilter filter, List<StyleRange> styles, StringBuilder builder, Map.Entry<String, String> entry) {
                builder.append(KEY_VALUE_DELIMITER);
                if (filter != null) {
                    KeyValueFilterFactory.KeyValueFilter.Range range = filter.getMatchingRangeForValue(entry.getValue());
                    this.addMatchStyleRange(range, builder.length(), styles);
                }
                builder.append(entry.getValue());
            }

            private void createKeyLabel(KeyValueFilterFactory.KeyValueFilter filter, List<StyleRange> styles, StringBuilder builder, Map.Entry<String, String> entry) {
                if (filter != null) {
                    KeyValueFilterFactory.KeyValueFilter.Range range = filter.getMatchingRangeForKey(entry.getKey());
                    this.addMatchStyleRange(range, builder.length(), styles);
                }
                builder.append(entry.getKey());
            }

            private void addMatchStyleRange(KeyValueFilterFactory.KeyValueFilter.Range range, int startPos, List<StyleRange> styles) {
                if (range == null) {
                    return;
                }
                styles.add(StyledTextUtils.createSelectedStyle((int)(startPos + range.start), (int)range.length));
            }
        }
    }
}

