/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.resource;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.jboss.tools.common.ui.JobUtils;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor;
import org.jboss.tools.openshift.common.core.utils.VariablesHelper;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.ui.utils.OpenShiftUIUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.OpenshiftUIConstants;
import org.jboss.tools.openshift.internal.ui.dialog.ResourceSummaryDialog;
import org.jboss.tools.openshift.internal.ui.job.CreateResourceJob;
import org.jboss.tools.openshift.internal.ui.wizard.resource.NewResourceWizardModel;
import org.jboss.tools.openshift.internal.ui.wizard.resource.ResourcePayloadPage;

public class NewResourceWizard
extends Wizard
implements IWorkbenchWizard {
    private NewResourceWizardModel model;

    public NewResourceWizard(NewResourceWizardModel model) {
        this.setWindowTitle("New OpenShift resource");
        this.setNeedsProgressMonitor(true);
        this.model = model;
    }

    public NewResourceWizard() {
        this(new NewResourceWizardModel());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Connection connection = (Connection)UIUtils.getFirstElement((ISelection)selection, Connection.class);
        if (connection == null) {
            IProject project = (IProject)UIUtils.getFirstElement((ISelection)selection, IProject.class);
            if (project != null) {
                this.model.setConnection(ConnectionsRegistryUtil.getConnectionFor((IResource)project));
                this.model.setProject(project);
            }
        } else {
            this.model.setConnection(connection);
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)new ResourcePayloadPage((IWizard)this, this.model));
    }

    public boolean performFinish() {
        boolean success = false;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = OpenshiftUIConstants.URL_VALIDATOR.isValid(this.model.getSource()) ? new URL(this.model.getSource()).openStream() : new FileInputStream(VariablesHelper.replaceVariables((String)this.model.getSource()));){
                final CreateResourceJob createJob = new CreateResourceJob(this.model.getProject(), is);
                createJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        IStatus status = event.getResult();
                        if (JobUtils.isOk((IStatus)status) || JobUtils.isWarning((IStatus)status)) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    new ResourceSummaryDialog(NewResourceWizard.this.getShell(), createJob.getResource(), "Create Resource Summary", "Results of creating the resource(s)").open();
                                }
                            });
                            OpenShiftUIUtils.showOpenShiftExplorer();
                        }
                    }
                });
                IStatus status = WizardUtils.runInWizard((Job)createJob, (DelegatingProgressMonitor)createJob.getDelegatingProgressMonitor(), (IWizardContainer)this.getContainer());
                success = this.isSuccess(status);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | InterruptedException | InvocationTargetException e) {
            OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)e);
            success = false;
        }
        return success;
    }

    private boolean isSuccess(IStatus status) {
        return JobUtils.isOk((IStatus)status) || JobUtils.isWarning((IStatus)status);
    }
}

