/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.resource;

import com.openshift.restclient.OpenShiftException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.VariablesHelper;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.utils.FileValidator;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.OpenshiftUIConstants;
import org.jboss.tools.openshift.internal.ui.job.CreateResourceJob;
import org.jboss.tools.openshift.internal.ui.wizard.common.AbstractProjectPage;
import org.jboss.tools.openshift.internal.ui.wizard.resource.IResourcePayloadPageModel;

public class ResourcePayloadPage
extends AbstractProjectPage<IResourcePayloadPageModel> {
    public ResourcePayloadPage(IWizard wizard, IResourcePayloadPageModel model) {
        super(wizard, model, "Select resource payload", "Select the file or workspace file from where the resource will be created", "resourcePayload");
    }

    @Override
    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        super.doCreateControls(parent, dbc);
        this.createPayloadSourceControls(parent, dbc);
    }

    private void createPayloadSourceControls(Composite parent, DataBindingContext dbc) {
        Group sourceGroup = new Group(parent, 0);
        sourceGroup.setText("Source");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(3, 1).hint(-1, -1).applyTo((Control)sourceGroup);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 6).spacing(6, 6).applyTo((Composite)sourceGroup);
        this.createLocalSourceControls(dbc, sourceGroup);
    }

    private void createLocalSourceControls(DataBindingContext dbc, Group sourceGroup) {
        Label label = new Label((Composite)sourceGroup, 0);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)label);
        label.setText("Enter a file path (workspace or local) or a full URL.");
        Text sourceText = new Text((Composite)sourceGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)sourceText);
        ISWTObservableValue source = WidgetProperties.text((int)24).observe((Widget)sourceText);
        WritableValue sourceStatus = new WritableValue((Object)Status.OK_STATUS, IStatus.class);
        ResourceContentValidator contentValidator = new ResourceContentValidator((WritableValue<IStatus>)sourceStatus);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)source).validatingBeforeSet((IValidator)contentValidator)).to(BeanProperties.value((String)"source").observe((Object)this.model)).validatingBeforeSet((IValidator)contentValidator)).in(dbc);
        MultiValidator validator = new MultiValidator((IObservableValue)source){
            private final /* synthetic */ IObservableValue val$source;
            {
                this.val$source = iObservableValue;
            }

            protected IStatus validate() {
                String sourceValue = (String)this.val$source.getValue();
                if (StringUtils.isEmpty((String)sourceValue)) {
                    return ValidationStatus.cancel((String)"You need to provide a file path or an URL");
                }
                return !OpenshiftUIConstants.URL_VALIDATOR.isValid(sourceValue) && !ResourcePayloadPage.isFile(sourceValue) ? ValidationStatus.error((String)(String.valueOf(sourceValue) + " is not a file")) : ValidationStatus.ok();
            }
        };
        dbc.addValidationStatusProvider((ValidationStatusProvider)validator);
        dbc.addValidationStatusProvider((ValidationStatusProvider)new MultiValidator((IObservableValue)source, sourceStatus){
            private final /* synthetic */ IObservableValue val$source;
            private final /* synthetic */ WritableValue val$sourceStatus;
            {
                this.val$source = iObservableValue;
                this.val$sourceStatus = writableValue;
            }

            protected IStatus validate() {
                this.val$source.getValue();
                return (IStatus)this.val$sourceStatus.getValue();
            }
        });
        ControlDecorationSupport.create((ValidationStatusProvider)validator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Button btnBrowseFiles = new Button((Composite)sourceGroup, 0);
        btnBrowseFiles.setText("Browse File System...");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)btnBrowseFiles);
        btnBrowseFiles.addSelectionListener((SelectionListener)this.onFileSystemBrowseClicked());
        Button btnBrowseWorkspaceFiles = new Button((Composite)sourceGroup, 0);
        btnBrowseWorkspaceFiles.setText("Browse Workspace...");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)btnBrowseWorkspaceFiles);
        btnBrowseWorkspaceFiles.addSelectionListener(this.onBrowseWorkspaceClicked());
    }

    private SelectionAdapter onFileSystemBrowseClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = this.createFileDialog(((IResourcePayloadPageModel)ResourcePayloadPage.this.model).getSource());
                String file = dialog.open();
                ResourcePayloadPage.this.setLocalSourceFileName(file);
            }

            private FileDialog createFileDialog(String selectedFile) {
                FileDialog dialog = new FileDialog(ResourcePayloadPage.this.getShell(), 4096);
                dialog.setText("Select an OpenShift resource");
                dialog.setFilterExtensions(new String[]{"*.json"});
                if (ResourcePayloadPage.exists(selectedFile)) {
                    File file = new File(selectedFile);
                    if (file.isFile()) {
                        file = file.getParentFile();
                    }
                    dialog.setFilterPath(file.getAbsolutePath());
                }
                return dialog;
            }
        };
    }

    private SelectionListener onBrowseWorkspaceClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = UIUtils.createFileDialog((String)((IResourcePayloadPageModel)ResourcePayloadPage.this.model).getSource(), (String)"Select an OpenShift resource", (String)"Select an OpenShift resource (*.json)", (String)"json", null);
                dialog.setValidator((ISelectionStatusValidator)new FileValidator());
                if (dialog.open() == 0 && dialog.getFirstResult() instanceof IFile) {
                    String path = ((IFile)dialog.getFirstResult()).getFullPath().toString();
                    String file = VariablesHelper.addWorkspacePrefix((String)path);
                    ResourcePayloadPage.this.setLocalSourceFileName(file);
                }
            }
        };
    }

    private void setLocalSourceFileName(String file) {
        if (file == null || !ResourcePayloadPage.isFile(file)) {
            return;
        }
        try {
            ((IResourcePayloadPageModel)this.model).setSource(file);
        }
        catch (OpenShiftException | ClassCastException ex) {
            IStatus status = ValidationStatus.error((String)ex.getMessage(), (Throwable)ex);
            OpenShiftUIActivator.getDefault().getLogger().logStatus(status);
            ErrorDialog.openError((Shell)this.getShell(), (String)"Openshift resource error", (String)NLS.bind((String)"The file \"{0}\" is not an OpenShift resource.", (Object)file), (IStatus)status);
        }
    }

    @Override
    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)12, (WizardPage)this, (DataBindingContext)dbc);
    }

    class ResourceContentValidator
    implements IValidator {
        private final WritableValue<IStatus> source;

        ResourceContentValidator(WritableValue<IStatus> source) {
            this.source = source;
        }

        public IStatus validate(Object value) {
            final String svalue = (String)value;
            if (!OpenshiftUIConstants.URL_VALIDATOR.isValid(svalue) && ResourcePayloadPage.isFile(svalue)) {
                Job job = new Job("Checking OpenShift resource content"){

                    protected IStatus run(IProgressMonitor monitor) {
                        IStatus status;
                        try {
                            Throwable throwable = null;
                            Object var4_5 = null;
                            try (FileInputStream s = new FileInputStream(VariablesHelper.replaceVariables((String)svalue));){
                                status = CreateResourceJob.loadResource(((IResourcePayloadPageModel)ResourcePayloadPage.this.model).getProject(), s, null);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            status = ValidationStatus.error((String)e.getLocalizedMessage());
                        }
                        IStatus fstatus = status;
                        ResourceContentValidator.this.source.getRealm().asyncExec(() -> ResourceContentValidator.this.source.setValue((Object)fstatus));
                        return ValidationStatus.OK_STATUS;
                    }
                };
                job.schedule();
            }
            return ValidationStatus.ok();
        }
    }
}

