/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.jboss.tools.project.examples.internal.Messages;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectModelElement;

@XmlRootElement(name="category")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class ProjectExampleCategory
implements ProjectModelElement,
Comparable<ProjectExampleCategory> {
    public static String OTHER = Messages.Category_Other;
    private String name;
    @XmlTransient
    private List<ProjectExample> projects = new ArrayList<ProjectExample>();
    private String description;
    private int priority = 0x7FFFFFFE;

    public ProjectExampleCategory() {
    }

    public ProjectExampleCategory(String name) {
        this();
        this.setName(name);
    }

    @Override
    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ProjectExample> getProjects() {
        if (this.projects == null) {
            this.projects = new ArrayList<ProjectExample>(0);
        }
        return this.projects;
    }

    public void setProjects(List<ProjectExample> projects) {
        this.projects = projects;
    }

    @Override
    @XmlAttribute
    public String getDescription() {
        return this.description;
    }

    @Override
    @XmlAttribute
    public String getShortDescription() {
        return this.getName();
    }

    @XmlAttribute
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.priority;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectExampleCategory other = (ProjectExampleCategory)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.priority == other.priority;
    }

    @Override
    public int compareTo(ProjectExampleCategory o) {
        if (o == null) {
            return 1;
        }
        int other = o.getPriority();
        if (other < this.priority) {
            return 1;
        }
        if (other > this.priority) {
            return -1;
        }
        if (this.name == null) {
            return -1;
        }
        if (OTHER.equals(this.name)) {
            return 1;
        }
        return this.name.compareTo(o.getName());
    }

    public String toString() {
        return "ProjectExampleCategory [name=" + this.name + ", description=" + this.description + ", priority=" + this.priority + "]";
    }
}

