/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.tools.runtime.core.Messages;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;

public class JBossRuntimeLocator {
    private static final int DEPTH = 10;

    public List<RuntimeDefinition> searchForRuntimes(String path, IProgressMonitor monitor) {
        return this.searchForRuntimes((IPath)new Path(path), monitor);
    }

    public List<RuntimeDefinition> searchForRuntimes(IPath path, IProgressMonitor monitor) {
        ArrayList<RuntimeDefinition> collector = new ArrayList<RuntimeDefinition>();
        this.searchForRuntimes(collector, path, monitor);
        return collector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void searchForRuntimes(List<RuntimeDefinition> runtimeCollector, IPath path, IProgressMonitor monitor) {
        File[] files = null;
        if (path != null) {
            File root = path.toFile();
            if (!root.isDirectory()) return;
            files = new File[]{root};
        } else {
            files = File.listRoots();
        }
        if (files != null) {
            int size = files.length;
            monitor.beginTask("Searching " + path.toOSString(), size * 100);
            int work = 100 / size;
            int i = 0;
            while (i < size) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (files[i] != null && files[i].isDirectory()) {
                    this.searchDirectory(files[i], runtimeCollector, 10, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                }
                monitor.worked(20);
                ++i;
            }
            monitor.done();
            return;
        } else {
            monitor.beginTask("Searching " + path.toOSString(), 1);
            monitor.worked(1);
            monitor.done();
        }
    }

    public void searchDirectory(File directory, List<RuntimeDefinition> runtimeCollector, int depth, IProgressMonitor monitor) {
        Set<IRuntimeDetector> runtimeDetectors = RuntimeCoreActivator.getDefault().getRuntimeDetectors();
        this.searchDirectory(directory, runtimeCollector, depth, runtimeDetectors, monitor);
    }

    public void searchDirectory(File directory, List<RuntimeDefinition> runtimeCollector, int depth, Set<IRuntimeDetector> runtimeDetectors, IProgressMonitor monitor) {
        if (depth == 0 || monitor.isCanceled() || directory == null || !directory.isDirectory()) {
            return;
        }
        int workSize = 1000 + 10 * runtimeDetectors.size();
        monitor.beginTask(String.valueOf(Messages.JBossRuntimeLocator_Searching) + directory.getAbsolutePath(), workSize);
        monitor.setTaskName(String.valueOf(Messages.JBossRuntimeLocator_Searching) + directory.getAbsolutePath());
        for (IRuntimeDetector detector : runtimeDetectors) {
            if (monitor.isCanceled()) {
                return;
            }
            if (!detector.isEnabled()) {
                monitor.worked(10);
                continue;
            }
            RuntimeDefinition runtimeDefinition = detector.getRuntimeDefinition(directory, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            if (runtimeDefinition == null) continue;
            runtimeCollector.add(runtimeDefinition);
            monitor.done();
            return;
        }
        File[] files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        SubProgressMonitor childrenMonitor = new SubProgressMonitor(monitor, 1000);
        childrenMonitor.beginTask("", 100 * files.length);
        if (files != null) {
            int size = files.length;
            int i = 0;
            while (i < size) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.searchDirectory(files[i], runtimeCollector, depth - 1, runtimeDetectors, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)childrenMonitor, 100));
                ++i;
            }
        }
        childrenMonitor.done();
    }
}

