/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.extract.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.runtime.core.extract.IOverwrite;
import org.jboss.tools.runtime.core.extract.internal.IExtractUtility;

public class UnzipUtility
implements IExtractUtility {
    private static String EXTRACTING = "Extracting ...";
    private static final String SEPARATOR = "/";
    private File file;
    private String discoveredRoot = null;
    private boolean rootEntryImpossible = false;

    public UnzipUtility(File file) {
        this.file = file;
    }

    @Override
    public IStatus extract(File destination, IOverwrite overwriteQuery, IProgressMonitor monitor) {
        if (this.file == null || !this.file.exists()) {
            return new Status(4, "org.jboss.tools.runtime.core", "Error opening zip file: " + this.file.getAbsolutePath() + "; File does not exist");
        }
        String possibleRoot = null;
        ZipFile zipFile = null;
        int overwrite = 2;
        destination.mkdirs();
        try {
            zipFile = new ZipFile(this.file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            monitor.beginTask(EXTRACTING, zipFile.size());
            while (entries.hasMoreElements()) {
                monitor.worked(1);
                if (monitor.isCanceled() || overwrite == 4) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                File entryFile2 = new File(destination, entryName);
                monitor.subTask(entry.getName());
                if (overwrite != 1 && overwrite != 3 && entryFile2.exists()) {
                    overwrite = overwriteQuery.overwrite(entryFile2);
                    switch (overwrite) {
                        case 4: {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                    }
                }
                try {
                    if (!entryFile2.exists() || overwrite == 0 || overwrite == 1) {
                        this.createEntry(monitor, zipFile, entry, entryFile2);
                    }
                    if (this.rootEntryImpossible || this.discoveredRoot != null) continue;
                    if (entryName == null || entryName.isEmpty() || entryName.startsWith(SEPARATOR) || entryName.indexOf(SEPARATOR) == -1) {
                        this.rootEntryImpossible = true;
                        possibleRoot = null;
                        continue;
                    }
                    String directory = entryName.substring(0, entryName.indexOf(SEPARATOR));
                    if (possibleRoot == null) {
                        possibleRoot = directory;
                        continue;
                    }
                    if (directory.equals(possibleRoot)) continue;
                    this.rootEntryImpossible = true;
                    possibleRoot = null;
                }
                catch (IOException e) {
                    boolean isZipped;
                    block43: {
                        isZipped = false;
                        ZipInputStream test = null;
                        try {
                            try {
                                test = new ZipInputStream(new FileInputStream(this.file));
                                isZipped = test.getNextEntry() != null;
                            }
                            catch (IOException entryFile2) {
                                if (test != null) {
                                    try {
                                        test.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block43;
                            }
                        }
                        catch (Throwable throwable) {
                            if (test != null) {
                                try {
                                    test.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        if (test != null) {
                            try {
                                test.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    String msg = "Error opening zip file " + this.file.getAbsolutePath();
                    if (!isZipped) {
                        msg = String.valueOf(msg) + ";  file may not be a properly formated zip file.";
                    }
                    Status status = new Status(4, "org.jboss.tools.runtime.core", msg, (Throwable)e);
                    return status;
                }
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            monitor.done();
        }
        this.discoveredRoot = possibleRoot;
        return Status.OK_STATUS;
    }

    private void createEntry(IProgressMonitor monitor, ZipFile zipFile, ZipEntry entry, File entryFile) throws IOException, FileNotFoundException {
        monitor.setTaskName(String.valueOf(EXTRACTING) + entry.getName());
        if (entry.isDirectory()) {
            entryFile.mkdirs();
        } else {
            entryFile.getParentFile().mkdirs();
            InputStream in = null;
            FileOutputStream out = null;
            try {
                in = zipFile.getInputStream(entry);
                out = new FileOutputStream(entryFile);
                this.copy(in, out);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[16384];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getRoot(IProgressMonitor monitor) throws CoreException {
        if (this.discoveredRoot != null) {
            return this.discoveredRoot;
        }
        if (this.rootEntryImpossible) {
            return null;
        }
        monitor.beginTask("Locating root folder", 100);
        ZipFile zipFile = null;
        String root = null;
        try {
            zipFile = new ZipFile(this.file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            if (entries.hasMoreElements()) {
            }
            return root;
        }
        catch (IOException ioe) {
            Status s = new Status(4, "org.jboss.tools.runtime.core", ioe.getLocalizedMessage(), (Throwable)ioe);
            throw new CoreException((IStatus)s);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            monitor.worked(100);
            monitor.done();
        }
    }
}

