/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.internal;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.runtime.core.model.AbstractRuntimeDetectorDelegate;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.jboss.tools.runtime.core.model.IRuntimeDetectorDelegate;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;

public class RuntimeDetector
implements IRuntimeDetector {
    private String name;
    private String id;
    private String preferenceId;
    private int priority;
    private IRuntimeDetectorDelegate delegate;
    private boolean enabled;

    public RuntimeDetector(String name, String id, String preferenceId, int priority, IRuntimeDetectorDelegate delegate) {
        this.name = name;
        this.id = id;
        this.preferenceId = preferenceId;
        this.priority = priority;
        this.delegate = delegate;
        this.enabled = true;
    }

    public IRuntimeDetectorDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public RuntimeDefinition getRuntimeDefinition(File root, IProgressMonitor monitor) {
        if (this.delegate != null) {
            return this.delegate.getRuntimeDefinition(root, monitor);
        }
        return null;
    }

    @Override
    public String getVersion(RuntimeDefinition runtimeDefinition) {
        if (this.delegate != null) {
            return this.delegate.getVersion(runtimeDefinition);
        }
        return null;
    }

    @Override
    public boolean exists(RuntimeDefinition runtimeDefinition) {
        if (this.delegate != null) {
            return this.delegate.exists(runtimeDefinition);
        }
        return false;
    }

    @Override
    public int compareTo(IRuntimeDetector o) {
        int p2;
        if (this.equals(o)) {
            return 0;
        }
        int p1 = this.getPriority();
        int dif = p1 - (p2 = o.getPriority());
        if (dif != 0) {
            return dif;
        }
        return this.getId().compareTo(o.getId());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPreferenceId() {
        return this.preferenceId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IRuntimeDetector other = (IRuntimeDetector)obj;
        return !(this.id == null ? other.getId() != null : !this.id.equals(other.getId()));
    }

    @Override
    public boolean initializeRuntime(RuntimeDefinition runtimeDefinition) throws CoreException {
        if (this.delegate != null) {
            return this.delegate.initializeRuntime(runtimeDefinition);
        }
        return false;
    }

    @Override
    public RuntimeDefinition[] computeIncludedDefinitions(RuntimeDefinition runtimeDefinition) {
        if (this.delegate != null) {
            return this.delegate.computeIncludedDefinitions(runtimeDefinition);
        }
        return new RuntimeDefinition[0];
    }

    @Override
    @Deprecated
    public void initializeRuntimes(List<RuntimeDefinition> runtimeDefinitions) {
        if (this.delegate != null) {
            this.delegate.initializeRuntimes(runtimeDefinitions);
        }
    }

    @Override
    @Deprecated
    public void computeIncludedRuntimeDefinition(RuntimeDefinition runtimeDefinition) {
        if (this.delegate != null) {
            this.delegate.computeIncludedRuntimeDefinition(runtimeDefinition);
        }
    }

    public void refreshProblems(RuntimeDefinition def) {
        if (this.delegate != null && this.delegate instanceof AbstractRuntimeDetectorDelegate) {
            ((AbstractRuntimeDetectorDelegate)this.delegate).calculateProblems(def);
        }
    }
}

