/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.model;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.internal.RuntimeDetector;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.jboss.tools.runtime.core.model.IRuntimeDetectorDelegate;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimeDetectionProblem;

public abstract class AbstractRuntimeDetectorDelegate
implements IRuntimeDetectorDelegate {
    private boolean loggedWarning = false;

    @Override
    @Deprecated
    public void initializeRuntimes(List<RuntimeDefinition> runtimeDefinitions) {
    }

    @Override
    public boolean initializeRuntime(RuntimeDefinition runtimeDefinition) throws CoreException {
        this.initializeRuntimes(Collections.singletonList(runtimeDefinition));
        if (!this.loggedWarning) {
            RuntimeCoreActivator.pluginLog().logWarning("Runtime Detector " + this.findMyDetector().getId() + " is using a deprecated API call.");
            this.loggedWarning = true;
        }
        return false;
    }

    @Override
    public RuntimeDefinition getRuntimeDefinition(File root, IProgressMonitor monitor) {
        return null;
    }

    @Override
    @Deprecated
    public void computeIncludedRuntimeDefinition(RuntimeDefinition runtimeDefinition) {
    }

    @Override
    public String getVersion(RuntimeDefinition runtimeDefinition) {
        return runtimeDefinition.getVersion();
    }

    @Override
    public boolean exists(RuntimeDefinition runtimeDefinition) {
        return false;
    }

    @Deprecated
    protected boolean isEnabled() {
        IRuntimeDetector d = this.findMyDetector();
        return d.isEnabled();
    }

    @Deprecated
    protected void setEnabled(boolean enabled) {
        IRuntimeDetector d = this.findMyDetector();
        ((RuntimeDetector)d).setEnabled(enabled);
    }

    protected void loadIncludedDefinitions(RuntimeDefinition runtimeDefinition) {
        Set<IRuntimeDetector> s = this.getOtherRuntimeDetectors();
        for (IRuntimeDetector iNext : s) {
            if (!iNext.isEnabled()) continue;
            RuntimeDefinition[] result = iNext.computeIncludedDefinitions(runtimeDefinition);
            runtimeDefinition.getIncludedRuntimeDefinitions().addAll(Arrays.asList(result));
        }
    }

    @Override
    public RuntimeDefinition[] computeIncludedDefinitions(RuntimeDefinition def) {
        RuntimeDefinition wrap = new RuntimeDefinition(def.getName(), def.getVersion(), def.getType(), def.getLocation(), def.getDetector());
        this.computeIncludedRuntimeDefinition(wrap);
        List<RuntimeDefinition> included = wrap.getIncludedRuntimeDefinitions();
        return included.toArray(new RuntimeDefinition[included.size()]);
    }

    protected final RuntimeDefinition createDefinition(String name, String version, String type, File loc) {
        return new RuntimeDefinition(name, version, type, loc, this.findMyDetector());
    }

    protected final RuntimeDefinition createDefinition(String name, String version, String type, File loc, RuntimeDefinition parent) {
        RuntimeDefinition def = new RuntimeDefinition(name, version, type, loc, this.findMyDetector());
        def.setParent(parent);
        return def;
    }

    private Set<IRuntimeDetector> getOtherRuntimeDetectors() {
        Set<IRuntimeDetector> runtimeDetectors = RuntimeCoreActivator.getDefault().getRuntimeDetectors();
        TreeSet<IRuntimeDetector> cloned = new TreeSet<IRuntimeDetector>(runtimeDetectors);
        cloned.remove(this.findMyDetector());
        return cloned;
    }

    protected IRuntimeDetector findMyDetector() {
        Set<IRuntimeDetector> set = RuntimeCoreActivator.getDefault().getRuntimeDetectors();
        for (IRuntimeDetector d : set) {
            IRuntimeDetectorDelegate mightBeMe = ((RuntimeDetector)d).getDelegate();
            if (mightBeMe != this && !this.equals(mightBeMe)) continue;
            return d;
        }
        return null;
    }

    protected RuntimeDetectionProblem createDetectionProblem(String label, String description, int severity, int code) {
        return new RuntimeDetectionProblem(label, description, severity, code);
    }

    public void calculateProblems(RuntimeDefinition def) {
        def.setProblems(new RuntimeDetectionProblem[0]);
    }
}

