/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.runtime.core.Messages;

public class DownloadRuntime {
    public static final String PROPERTY_ALTERNATE_ID = "PROPERTY_ALTERNATE_ID";
    public static final String PROPERTY_REQUIRES_CREDENTIALS = "requiresCredentials";
    public static final String PROPERTY_INSTALLATION_METHOD = "installationMethod";
    private byte[] BUFFER = null;
    private String name;
    private String id;
    private String version;
    private String url;
    private String licenseURL;
    private String humanUrl;
    private String size = "?";
    private boolean disclaimer = true;
    private HashMap<String, Object> properties;
    private String installationMethod = "archive";

    public DownloadRuntime(String id, String name, String version, String url) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.url = url;
        this.properties = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DownloadRuntime other = (DownloadRuntime)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public boolean isDisclaimer() {
        return this.disclaimer;
    }

    public void setDisclaimer(boolean disclaimer) {
        this.disclaimer = disclaimer;
    }

    public void setLicenseURL(String url) {
        this.licenseURL = url;
    }

    public String getLicenceURL() {
        return this.licenseURL;
    }

    public String getLicense(IProgressMonitor monitor) throws CoreException {
        String string;
        URL url = null;
        ByteArrayOutputStream out = null;
        try {
            if (this.licenseURL == null) {
                return null;
            }
            url = new URL(this.licenseURL);
            InputStream in = url.openStream();
            out = new ByteArrayOutputStream();
            this.copyWithSize(in, out, null, 0);
            string = new String(out.toByteArray());
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.runtime.core", 0, NLS.bind((String)Messages.DownloadRuntime_Unable_to_fetch_license, (Object)e.getLocalizedMessage()), (Throwable)e));
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    private void copyWithSize(InputStream in, OutputStream out, IProgressMonitor monitor, int size) throws IOException {
        if (this.BUFFER == null) {
            this.BUFFER = new byte[8192];
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)size);
        int r = in.read(this.BUFFER);
        while (r >= 0) {
            out.write(this.BUFFER, 0, r);
            progress.worked(r);
            r = in.read(this.BUFFER);
        }
    }

    public String getHumanUrl() {
        return this.humanUrl;
    }

    public void setHumanUrl(String humanUrl) {
        this.humanUrl = humanUrl;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public String getInstallationMethod() {
        return this.installationMethod == null ? "archive" : this.installationMethod;
    }

    public void setInstallationMethod(String installationMethod) {
        this.installationMethod = installationMethod;
    }

    public String toString() {
        return "DownloadRuntime [BUFFER=" + Arrays.toString(this.BUFFER) + ", name=" + this.name + ", id=" + this.id + ", version=" + this.version + ", url=" + this.url + ", licenseURL=" + this.licenseURL + ", humanUrl=" + this.humanUrl + ", size=" + this.size + ", disclaimer=" + this.disclaimer + "]";
    }
}

