/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.tools.runtime.core.internal.RuntimeDetector;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.jboss.tools.runtime.core.model.RuntimeDetectionProblem;
import org.jboss.tools.runtime.core.model.RuntimePath;

public class RuntimeDefinition {
    private String name;
    private String version;
    private String type;
    private File location;
    private String description;
    private boolean enabled = true;
    private RuntimePath runtimePath;
    private List<RuntimeDefinition> includedRuntimeDefinitions = new ArrayList<RuntimeDefinition>();
    private RuntimeDefinition parent;
    private IRuntimeDetector detector;
    private RuntimeDetectionProblem[] problems;
    private HashMap<String, Object> properties;

    @Deprecated
    public RuntimeDefinition(String name, String version, String type, File location) {
        this.name = name;
        this.version = version;
        this.type = type;
        this.location = location;
        this.description = "";
        this.properties = new HashMap();
    }

    public RuntimeDefinition(String name, String version, String type, File location, IRuntimeDetector detector) {
        this(name, version, type, location);
        this.detector = detector;
    }

    public IRuntimeDetector getDetector() {
        return this.detector;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public File getLocation() {
        return this.location;
    }

    public void setLocation(File location) {
        this.location = location;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuntimeDefinition other = (RuntimeDefinition)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "RuntimeDefinition [name=" + this.name + ", version=" + this.version + ", type=" + this.type + ", location=" + this.location + "]";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RuntimePath getRuntimePath() {
        return this.runtimePath;
    }

    public void setRuntimePath(RuntimePath runtimePath) {
        this.runtimePath = runtimePath;
    }

    public List<RuntimeDefinition> getIncludedRuntimeDefinitions() {
        return this.includedRuntimeDefinitions;
    }

    public RuntimeDefinition getParent() {
        return this.parent;
    }

    public void setParent(RuntimeDefinition parent) {
        this.parent = parent;
    }

    public void setProblems(RuntimeDetectionProblem[] all) {
        this.problems = all;
    }

    public RuntimeDetectionProblem[] getProblems() {
        return this.problems == null ? new RuntimeDetectionProblem[]{} : this.problems;
    }

    public void setProperty(String s, Object o) {
        this.properties.put(s, o);
    }

    public Object getProperty(String s) {
        return this.properties.get(s);
    }

    public void refreshProblems() {
        if (this.detector != null && this.detector instanceof RuntimeDetector) {
            ((RuntimeDetector)this.detector).refreshProblems(this);
        }
    }
}

