/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.model.internal;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.jboss.tools.foundation.core.tasks.TaskModel;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.core.model.IRuntimeInstaller;
import org.jboss.tools.runtime.core.util.internal.DownloadRuntimeOperationUtility;

public class JavaJarRuntimeInstaller
implements IRuntimeInstaller {
    public static final String ID = "installer-jar";
    private static final String EXTERNAL_LAUNCH_CONFIG_TYPE = "org.eclipse.ui.externaltools.ProgramLaunchConfigurationType";
    private static final String EXTERNAL_LAUNCH_ATTR_LOCATION = "org.eclipse.ui.externaltools.ATTR_LOCATION";
    private static final String EXTERNAL_LAUNCH_ATTR_ARGS = "org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS";
    static final String JAVA_HOME_PROPERTY_KEY = "java.home";

    @Override
    public IStatus installRuntime(DownloadRuntime downloadRuntime, String unzipDirectory, String downloadDirectory, boolean deleteOnExit, TaskModel taskModel, IProgressMonitor monitor) {
        String user = (String)taskModel.getObject("dl.runtime.username");
        String pass = (String)taskModel.getObject("dl.runtime.password");
        monitor.beginTask("Install Runtime '" + downloadRuntime.getName() + "' ...", 100);
        monitor.worked(1);
        try {
            File f = new DownloadRuntimeOperationUtility().download(unzipDirectory, downloadDirectory, this.getDownloadUrl(downloadRuntime, taskModel), deleteOnExit, user, pass, taskModel, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
            ILaunchConfiguration lc = this.createExternalToolsLaunchConfiguration(f, unzipDirectory);
            ILaunch launch = lc.launch("run", (IProgressMonitor)new NullProgressMonitor());
            if (launch == null) {
                return new Status(4, "org.jboss.tools.runtime.core", "Unable to launch external command java -jar " + f.getAbsolutePath());
            }
            IProcess[] processes = launch.getProcesses();
            boolean finished = false;
            while (!monitor.isCanceled() && !finished) {
                boolean checkFinished = true;
                int i = 0;
                while (i < processes.length) {
                    checkFinished &= processes[i].isTerminated();
                    ++i;
                }
                finished = checkFinished;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    private String getDownloadUrl(DownloadRuntime downloadRuntime, TaskModel taskModel) {
        if (downloadRuntime != null) {
            String dlUrl = downloadRuntime.getUrl();
            if (dlUrl == null) {
                return (String)taskModel.getObject("dl.runtime.url");
            }
            return dlUrl;
        }
        return null;
    }

    private ILaunchConfiguration createExternalToolsLaunchConfiguration(File downloadedFile, String unzipDirectory) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(EXTERNAL_LAUNCH_CONFIG_TYPE);
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, manager.generateLaunchConfigurationName("java -jar " + downloadedFile.getAbsolutePath()));
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        File javaHome = null;
        if (install != null) {
            javaHome = install.getInstallLocation();
        } else {
            String jHome = System.getProperty(JAVA_HOME_PROPERTY_KEY);
            javaHome = new File(jHome);
        }
        Path path = new Path(javaHome.getAbsolutePath());
        path = Platform.getOS().equals("win32") ? path.append("bin").append("java.exe") : path.append("bin").append("java");
        wc.setAttribute(EXTERNAL_LAUNCH_ATTR_LOCATION, path.toOSString());
        wc.setAttribute(EXTERNAL_LAUNCH_ATTR_ARGS, "-DINSTALL_PATH=\"" + unzipDirectory + "\"  -jar " + downloadedFile.getAbsolutePath());
        ILaunchConfiguration config = wc.doSave();
        return config;
    }
}

