/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.runtime.core.internal.RuntimeExtensionManager;
import org.jboss.tools.runtime.core.model.IRuntimeDetectionResolution;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimeDetectionProblem;
import org.jboss.tools.runtime.core.model.RuntimePath;
import org.jboss.tools.runtime.ui.internal.Messages;
import org.jboss.tools.runtime.ui.internal.dialogs.RuntimeContentProvider;
import org.jboss.tools.runtime.ui.internal.dialogs.RuntimeLabelProvider;

public class RuntimeCheckboxTreeViewer
extends CheckboxTreeViewer {
    private Shell popupShell;
    private Table popupTable;

    public RuntimeCheckboxTreeViewer(Composite parent, Set<RuntimePath> runtimePaths2, int heightHint) {
        this(parent, runtimePaths2.toArray(new RuntimePath[runtimePaths2.size()]), heightHint);
    }

    public RuntimeCheckboxTreeViewer(Composite parent, RuntimePath[] runtimePaths2, int heightHint) {
        super(parent, 68100);
        Tree tree = this.getTree();
        GridData gd = new GridData(4, 4, true, true);
        GC gc = new GC((Drawable)parent);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        gd.minimumHeight = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)heightHint);
        tree.setLayoutData((Object)gd);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        String[] columnNames = new String[]{Messages.RuntimeCheckboxTreeViewer_Name, Messages.RuntimeCheckboxTreeViewer_Type, Messages.RuntimeCheckboxTreeViewer_Version, Messages.RuntimeCheckboxTreeViewer_Errors, Messages.RuntimeCheckboxTreeViewer_Location};
        int[] columnWidths = new int[]{200, 70, 60, 150, 150};
        int i = 0;
        while (i < columnNames.length) {
            TreeViewerColumn tc = new TreeViewerColumn((TreeViewer)this, 0);
            tc.getColumn().setText(columnNames[i]);
            tc.getColumn().setWidth(columnWidths[i]);
            ++i;
        }
        this.setLabelProvider((IBaseLabelProvider)new RuntimeLabelProvider());
        ArrayList<RuntimeDefinition> runtimeDefinitions = new ArrayList<RuntimeDefinition>();
        RuntimePath[] runtimePathArray = runtimePaths2;
        int n = runtimePaths2.length;
        int n2 = 0;
        while (n2 < n) {
            RuntimePath runtimePath = runtimePathArray[n2];
            runtimeDefinitions.addAll(Arrays.asList(runtimePath.getRuntimeDefinitions()));
            ++n2;
        }
        this.setContentProvider((IContentProvider)new RuntimeContentProvider(runtimeDefinitions));
        this.setInput(runtimeDefinitions);
        for (RuntimeDefinition definition : runtimeDefinitions) {
            this.setChecked(definition, definition.isEnabled());
        }
        this.addContentAssist();
    }

    private void addContentAssist() {
        this.popupShell = new Shell(this.getTree().getShell(), 16400);
        this.popupShell.setLayout((Layout)new FillLayout());
        this.popupTable = new Table((Composite)this.popupShell, 4);
        this.popupShell.setVisible(false);
        this.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (RuntimeCheckboxTreeViewer.this.popupShell.getVisible()) {
                    RuntimeCheckboxTreeViewer.this.popupShell.setVisible(false);
                } else {
                    RuntimeCheckboxTreeViewer.this.showContentAssist(event);
                }
            }
        });
        this.getTree().addListener(1, new Listener(){

            public void handleEvent(Event event) {
                switch (event.keyCode) {
                    case 0x1000002: {
                        int index = (RuntimeCheckboxTreeViewer.this.popupTable.getSelectionIndex() + 1) % RuntimeCheckboxTreeViewer.this.popupTable.getItemCount();
                        RuntimeCheckboxTreeViewer.this.popupTable.setSelection(index);
                        event.doit = false;
                        break;
                    }
                    case 0x1000001: {
                        int index = RuntimeCheckboxTreeViewer.this.popupTable.getSelectionIndex() - 1;
                        if (index < 0) {
                            index = RuntimeCheckboxTreeViewer.this.popupTable.getItemCount() - 1;
                        }
                        RuntimeCheckboxTreeViewer.this.popupTable.setSelection(index);
                        event.doit = false;
                        break;
                    }
                    case 13: {
                        if (!RuntimeCheckboxTreeViewer.this.popupShell.isVisible() || RuntimeCheckboxTreeViewer.this.popupTable.getSelectionIndex() == -1) break;
                        event.doit = false;
                        RuntimeCheckboxTreeViewer.this.contentAssistChosen();
                        break;
                    }
                    case 27: {
                        RuntimeCheckboxTreeViewer.this.popupShell.setVisible(false);
                    }
                }
            }
        });
        this.getTree().getShell().addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (RuntimeCheckboxTreeViewer.this.popupShell.isVisible() && (event.keyCode == 13 || event.keyCode == 27)) {
                    event.doit = false;
                }
            }
        });
        this.getTree().getShell().addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (RuntimeCheckboxTreeViewer.this.popupShell.isVisible() && event.detail == 2) {
                    event.doit = false;
                }
            }
        });
        Listener hideUnfocusedPopup = new Listener(){

            public void handleEvent(final Event event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Widget w = event.widget;
                        Control control = Display.getDefault().getFocusControl();
                        if (control == null || control != RuntimeCheckboxTreeViewer.this.getTree() && control != RuntimeCheckboxTreeViewer.this.popupTable) {
                            RuntimeCheckboxTreeViewer.this.popupShell.setVisible(false);
                        }
                    }
                });
            }
        };
        this.popupTable.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 27) {
                    RuntimeCheckboxTreeViewer.this.popupShell.setVisible(false);
                }
            }
        });
        this.popupTable.addListener(16, hideUnfocusedPopup);
        Listener hidePopup = new Listener(){

            public void handleEvent(Event event) {
                RuntimeCheckboxTreeViewer.this.popupShell.setVisible(false);
            }
        };
        this.getTree().getShell().addListener(12, hidePopup);
        this.getTree().getShell().addListener(10, hidePopup);
        this.popupTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                RuntimeCheckboxTreeViewer.this.contentAssistChosen();
            }
        });
    }

    private void contentAssistChosen() {
        RuntimeDefinition sel;
        RuntimeDetectionProblem[] s;
        int problemIndex = this.popupTable.getSelectionIndex();
        if (problemIndex != -1 && problemIndex < (s = (sel = this.getSelectedDefinition()).getProblems()).length) {
            final RuntimeDetectionProblem problem = s[problemIndex];
            IRuntimeDetectionResolution[] resolutions = RuntimeExtensionManager.getDefault().findResolutions(problem, sel);
            if (resolutions.length > 0) {
                resolutions[0].run(problem, sel);
                Object[] all = ((ITreeContentProvider)this.getContentProvider()).getElements(null);
                int i = 0;
                while (i < all.length) {
                    if (all[i] instanceof RuntimeDefinition) {
                        ((RuntimeDefinition)all[i]).refreshProblems();
                    }
                    ++i;
                }
                this.refresh();
            } else {
                this.popupShell.setVisible(false);
                StatusDialog d = new StatusDialog(this.getTree().getShell()){

                    protected Control createDialogArea(Composite parent) {
                        Composite composite = (Composite)super.createDialogArea(parent);
                        Label label = new Label(composite, 64);
                        GridData layoutData = new GridData(4, 0x1000000, true, false);
                        layoutData.widthHint = this.convertWidthInCharsToPixels(80);
                        label.setLayoutData((Object)layoutData);
                        label.setText("No quickfixes were found for the problem: " + problem.getDescription());
                        this.updateStatus((IStatus)new Status(4, "org.jboss.tools.runtime.ui", "No quickfixes found for the selected problem"));
                        Dialog.applyDialogFont((Control)composite);
                        return composite;
                    }
                };
                d.setTitle("No quickfix available");
                d.open();
            }
        }
        this.popupShell.setVisible(false);
    }

    private void showContentAssist(MouseEvent event) {
        Rectangle itemBounds = this.findItemBounds(event, 3);
        if (itemBounds != null) {
            String[] text;
            int i;
            this.popupTable.removeAll();
            RuntimeDefinition selected = this.getSelectedDefinition();
            if (selected != null) {
                RuntimeDetectionProblem[] s = selected.getProblems();
                i = 0;
                while (i < s.length) {
                    String text2 = s[i].getLabel();
                    if (text2 != null) {
                        int sev = s[i].getSeverity();
                        TableItem ti = new TableItem(this.popupTable, 0);
                        ti.setText(text2);
                        Image sevImage = null;
                        if (sev == 4) {
                            sevImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
                        } else if (sev == 2) {
                            sevImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_WARNING");
                        }
                        if (sevImage != null) {
                            ti.setImage(sevImage);
                        }
                    }
                    ++i;
                }
            }
            if ((text = this.getQuickfixTextForCurrentSelection()) == null || text.length == 0) {
                return;
            }
            i = 0;
            while (i < text.length) {
                ++i;
            }
            Rectangle textBounds = Display.getDefault().map((Control)this.getTree(), null, itemBounds);
            this.popupShell.setBounds(textBounds.x, textBounds.y + textBounds.height, textBounds.width > 250 ? textBounds.width : 250, 150);
            this.popupTable.setEnabled(true);
            this.popupShell.setVisible(true);
        }
    }

    private String[] getQuickfixTextForCurrentSelection() {
        RuntimeDefinition selected = this.getSelectedDefinition();
        if (selected != null) {
            RuntimeDetectionProblem[] s = selected.getProblems();
            ArrayList<String> ret = new ArrayList<String>();
            int i = 0;
            while (i < s.length) {
                ret.add(s[i].getLabel());
                ++i;
            }
            return ret.toArray(new String[ret.size()]);
        }
        return new String[0];
    }

    private RuntimeDefinition getSelectedDefinition() {
        Object f;
        ISelection sel = this.getSelection();
        if (sel instanceof IStructuredSelection && (f = ((IStructuredSelection)sel).getFirstElement()) instanceof RuntimeDefinition) {
            return (RuntimeDefinition)f;
        }
        return null;
    }

    private Rectangle findItemBounds(MouseEvent event, int soughtColumn) {
        Point pt = new Point(event.x, event.y);
        TreeItem item = this.getTree().getItem(pt);
        if (item != null) {
            int i = 0;
            int n = this.getTree().getColumnCount();
            while (i < n) {
                Rectangle rect = item.getBounds(i);
                if (rect.contains(pt) && i == soughtColumn) {
                    return rect;
                }
                ++i;
            }
        }
        return null;
    }

    public void updateInput(RuntimePath[] runtimePaths) {
        this.setInput(null);
        ArrayList<RuntimeDefinition> runtimeDefinitions = new ArrayList<RuntimeDefinition>();
        RuntimePath[] runtimePathArray = runtimePaths;
        int n = runtimePaths.length;
        int n2 = 0;
        while (n2 < n) {
            RuntimePath runtimePath = runtimePathArray[n2];
            runtimeDefinitions.addAll(Arrays.asList(runtimePath.getRuntimeDefinitions()));
            ++n2;
        }
        this.setInput(runtimeDefinitions);
        for (RuntimeDefinition runtimeDefinition : runtimeDefinitions) {
            this.setChecked(runtimeDefinition, runtimeDefinition.isEnabled());
        }
    }
}

