/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.core.exceptions;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.vpe.preview.core.Activator;
import org.jboss.tools.vpe.preview.core.exceptions.LinkStatusPart;
import org.jboss.tools.vpe.preview.core.exceptions.Messages;
import org.jboss.tools.vpe.xulrunner.XulRunnerBundleNotFoundException;
import org.jboss.tools.vpe.xulrunner.XulRunnerException;
import org.jboss.tools.vpe.xulrunner.browser.XulRunnerBrowser;

public class XulRunnerErrorWrapper {
    public static final String ID = "org.jboss.tools.vpe.editor";

    public void showError(Composite parent, Throwable originalThrowable) {
        Throwable throwable = this.wrapXulRunnerError(originalThrowable);
        String errorMessage = throwable instanceof XulRunnerBundleNotFoundException && "org.mozilla.xulrunner.win32.win32.x86_64".equals(((XulRunnerBundleNotFoundException)throwable).getBundleId()) ? Messages.MOZILLA_EXPERIMENTAL_SUPPORT : MessageFormat.format(Messages.MOZILLA_LOADING_ERROR, throwable.getMessage());
        Activator.logError(throwable, errorMessage);
        parent.setLayout((Layout)new GridLayout());
        Composite statusComposite = new Composite(parent, 0);
        Color bgColor = parent.getDisplay().getSystemColor(25);
        Color fgColor = parent.getDisplay().getSystemColor(24);
        parent.setBackground(bgColor);
        parent.setForeground(fgColor);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        statusComposite.setLayoutData((Object)gridData);
        Status displayStatus = new Status(4, "org.jboss.tools.vpe.preview.core", errorMessage, throwable);
        new LinkStatusPart(statusComposite, (IStatus)displayStatus, new Composite(parent, 0));
        final Link link = new Link(parent, 64);
        link.setLayoutData((Object)new GridData(128));
        link.setBackground(bgColor);
        link.setText(Messages.MOZILLA_LOADING_ERROR_LINK_TEXT);
        link.setToolTipText(Messages.MOZILLA_LOADING_ERROR_LINK);
        link.setForeground(link.getDisplay().getSystemColor(9));
        link.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                BusyIndicator.showWhile((Display)link.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        URL theURL = null;
                        try {
                            theURL = new URL(Messages.MOZILLA_LOADING_ERROR_LINK);
                        }
                        catch (MalformedURLException e) {
                            Activator.logError(e);
                        }
                        new BrowserUtility().checkedCreateExternalBrowser(theURL.toString(), "org.jboss.tools.vpe.preview.core", Activator.getDefault().getLog());
                    }
                });
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        parent.getParent().layout(true, true);
    }

    protected Throwable wrapXulRunnerError(Throwable originalThrowable) {
        Throwable throwable = originalThrowable;
        if (throwable instanceof SWTError && throwable.getMessage() != null) {
            String message = throwable.getMessage();
            if (message.contains("XPCOM error ") || message.contains(" [Failed to use detected XULRunner: ") || message.contains(" [Unknown Mozilla path (MOZILLA_FIVE_HOME not set)]") || message.contains(" [Mozilla GTK2 required (GTK1.2 detected)]") || message.contains(" [MOZILLA_FIVE_HOME='") || message.contains(" [MOZILLA_FIVE_HOME may not point at an embeddable GRE] [NS_InitEmbedding ")) {
                throwable = new XulRunnerException(originalThrowable);
            } else if (message.contains(" [Could not detect registered XULRunner to use]")) {
                throwable = System.getProperty("org.eclipse.swt.browser.XULRunnerPath") == null && !XulRunnerBrowser.isCurrentPlatformOfficiallySupported() ? new XulRunnerException(MessageFormat.format(Messages.CURRENT_PLATFORM_IS_NOT_SUPPORTED, XulRunnerBrowser.CURRENT_PLATFORM_ID), originalThrowable) : new XulRunnerException(originalThrowable);
            } else if (message.contains("not supported with GTK 3 as XULRunner is not ported for GTK 3 yet")) {
                throwable = new XulRunnerException(Messages.GTK3_IS_NOT_SUPPORTED, originalThrowable);
            }
        }
        return throwable;
    }
}

