/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.core.server;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.vpe.preview.core.Activator;
import org.jboss.tools.vpe.preview.core.transform.ResourceAcceptor;
import org.jboss.tools.vpe.preview.core.transform.VpvController;

public class VpvSocketProcessor
implements Runnable {
    public static final String INITIAL_REQUEST_LINE = "Initial request line";
    public static final String REFERER = "Referer";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String HOST = "Host";
    public static final String UTF_8 = "UTF-8";
    private Socket clientSocket;
    private VpvController vpvController;

    public VpvSocketProcessor(Socket clientSocket, VpvController vpvController) {
        this.clientSocket = clientSocket;
        this.vpvController = vpvController;
    }

    @Override
    public void run() {
        try {
            BufferedReader inputFromClient = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream(), UTF_8));
            DataOutputStream outputToClient = new DataOutputStream(this.clientSocket.getOutputStream());
            String initialContextLine = this.getInitialRequestLine(inputFromClient);
            if (initialContextLine != null) {
                Map<String, String> requestHeader = this.getRequestHeader(inputFromClient);
                if (requestHeader.isEmpty()) {
                    this.processNotFound(outputToClient);
                    return;
                }
                this.processRequest(initialContextLine, requestHeader, outputToClient, inputFromClient);
            }
        }
        catch (IOException e) {
            Activator.logError(e);
        }
    }

    private void processRequest(String initialRequestLine, Map<String, String> requestHeaders, final DataOutputStream outputToClient, final BufferedReader inputFromClient) {
        String httpRequestString = this.getHttpRequestString(initialRequestLine);
        Map<String, String> queryParametersMap = this.parseUrlParameters(httpRequestString);
        String path = this.getPath(httpRequestString);
        String webrootPath = this.getWebrootPath(queryParametersMap, requestHeaders);
        String fullPath = String.valueOf(webrootPath) + path;
        Integer viewId = this.getViewId(queryParametersMap);
        this.vpvController.getResource(fullPath, viewId, new ResourceAcceptor(){

            @Override
            public void acceptText(String text, String mimeType) {
                String etag = this.formEtagForText();
                String responceHeader = VpvSocketProcessor.this.getOkResponceHeader(mimeType, etag);
                this.sendOkResponse(responceHeader, outputToClient, text);
            }

            @Override
            public void acceptFile(File file, String mimeType) {
                String okHeader = VpvSocketProcessor.this.getOkResponceHeader(mimeType, null);
                this.sendOkResponse(okHeader, outputToClient, file);
            }

            @Override
            public void acceptError() {
                VpvSocketProcessor.this.processNotFound(outputToClient);
            }

            private String formEtagForText() {
                return String.valueOf(new Date().getTime());
            }

            private void sendOkResponse(String header, DataOutputStream outputToclient, File file) {
                try {
                    try {
                        outputToClient.write(header.getBytes(VpvSocketProcessor.UTF_8));
                        VpvSocketProcessor.this.sendFile(file, outputToClient);
                    }
                    catch (IOException iOException) {
                        try {
                            outputToClient.close();
                            inputFromClient.close();
                            VpvSocketProcessor.this.clientSocket.close();
                        }
                        catch (IOException e) {
                            Activator.logError(e);
                        }
                    }
                }
                finally {
                    try {
                        outputToClient.close();
                        inputFromClient.close();
                        VpvSocketProcessor.this.clientSocket.close();
                    }
                    catch (IOException e) {
                        Activator.logError(e);
                    }
                }
            }

            private void sendOkResponse(String header, DataOutputStream outputToclient, String text) {
                try {
                    try {
                        outputToClient.write(header.getBytes(VpvSocketProcessor.UTF_8));
                        outputToClient.write(text.getBytes(VpvSocketProcessor.UTF_8));
                    }
                    catch (IOException iOException) {
                        try {
                            outputToClient.close();
                            inputFromClient.close();
                            VpvSocketProcessor.this.clientSocket.close();
                        }
                        catch (IOException e) {
                            Activator.logError(e);
                        }
                    }
                }
                finally {
                    try {
                        outputToClient.close();
                        inputFromClient.close();
                        VpvSocketProcessor.this.clientSocket.close();
                    }
                    catch (IOException e) {
                        Activator.logError(e);
                    }
                }
            }
        });
    }

    private void processNotFound(DataOutputStream outputToClient) {
        String notFoundHeader = this.getNotFoundHeader();
        try {
            try {
                outputToClient.write(notFoundHeader.getBytes(UTF_8));
            }
            catch (IOException iOException) {
                try {
                    outputToClient.close();
                }
                catch (IOException e) {
                    Activator.logError(e);
                }
            }
        }
        finally {
            try {
                outputToClient.close();
            }
            catch (IOException e) {
                Activator.logError(e);
            }
        }
    }

    private Map<String, String> parseUrlParameters(String urlString) {
        int delimiterPosition = this.getDilimiterPosition(urlString);
        if (delimiterPosition == -1) {
            return Collections.emptyMap();
        }
        String parameterString = urlString.substring(delimiterPosition + 1, urlString.length());
        String[] parameterArray = parameterString.split("&");
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        String[] stringArray = parameterArray;
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (param.length() > 0) {
                String value;
                String[] nameValue = param.split("=");
                String name = nameValue[0];
                String string = value = nameValue.length > 1 ? nameValue[1] : null;
                if (value != null) {
                    try {
                        value = URLDecoder.decode(value, UTF_8);
                    }
                    catch (UnsupportedEncodingException e) {
                        Activator.logError(e);
                    }
                }
                parameterMap.put(name, value);
            }
            ++n2;
        }
        return parameterMap;
    }

    int getDilimiterPosition(String httpRequestString) {
        return httpRequestString.indexOf(63);
    }

    private String getHttpRequestString(String initialRequestLine) {
        String[] data = initialRequestLine.split(" ");
        return data[1];
    }

    private String getPath(String httpRequestString) {
        String path = httpRequestString;
        int delimiter = this.getDilimiterPosition(httpRequestString);
        int pathEnd = delimiter != -1 ? delimiter : path.length();
        path = path.substring(0, pathEnd);
        try {
            path = URLDecoder.decode(path, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            Activator.logError(e);
        }
        return path;
    }

    private String getWebrootPath(Map<String, String> queryParametersMap, Map<String, String> requestHeaders) {
        String referer;
        String path = queryParametersMap.get("webroot");
        if (path == null && (referer = requestHeaders.get(REFERER)) != null) {
            path = this.parseUrlParameters(referer).get("webroot");
        }
        return path != null ? path : "";
    }

    private Integer getViewId(Map<String, String> queryParametersMap) {
        String viewId = queryParametersMap.get("viewId");
        if (viewId != null) {
            return Integer.parseInt(viewId);
        }
        return null;
    }

    private String getInitialRequestLine(BufferedReader inputFromClient) {
        String line = null;
        try {
            line = inputFromClient.readLine();
        }
        catch (IOException e) {
            Activator.logError(e);
        }
        if (line == null || line.isEmpty()) {
            return null;
        }
        return line;
    }

    private Map<String, String> getRequestHeader(BufferedReader inputFromClient) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        try {
            String line;
            while ((line = inputFromClient.readLine()) != null && !line.isEmpty()) {
                int colonIndex = line.indexOf(58);
                if (colonIndex < 0) continue;
                String key = line.substring(0, colonIndex).trim();
                String value = null;
                if (colonIndex < line.length()) {
                    value = line.substring(colonIndex + 1).trim();
                }
                requestHeaders.put(key, value);
            }
        }
        catch (IOException e) {
            Activator.logError(e);
        }
        return requestHeaders;
    }

    private void sendFile(File file, DataOutputStream outputToClient) {
        FileInputStream fileInputStream = null;
        try {
            try {
                int bytesRead;
                fileInputStream = new FileInputStream(file);
                byte[] buffer = new byte[1024];
                while ((bytesRead = fileInputStream.read(buffer)) >= 0) {
                    outputToClient.write(buffer, 0, bytesRead);
                }
            }
            catch (FileNotFoundException e) {
                Activator.logError(e);
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException e2) {
                    Activator.logError(e2);
                }
            }
            catch (IOException iOException) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException e) {
                    Activator.logError(e);
                }
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                Activator.logError(e);
            }
        }
    }

    public Socket getClientSocket() {
        return this.clientSocket;
    }

    public void setClientSocket(Socket clientSocket) {
        this.clientSocket = clientSocket;
    }

    private String getOkResponceHeader(String mimeType, String eTag) {
        String responceHeader = "HTTP/1.1 200 OK\r\nServer: VPV server\r\nContent-Type: " + mimeType + "; charset=UTF-8\r\n" + "Cache-Control: max-age=0\r\n" + "Etag: " + eTag + "\r\n" + "Connection: close\r\n\r\n";
        return responceHeader;
    }

    private String getNotFoundHeader() {
        String responceHeader = "HTTP/1.1 404 Not Found\r\nContent-Type: text/html; charset=UTF-8\r\nConnection: close\r\n\r\n<!DOCTYPE HTML><h1>404 Not Found<//h1>";
        return responceHeader;
    }
}

