/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.core.template.util;

import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class VpeStyleUtil {
    public static final String UNRESOLVED_IMAGE_PATH = "unresolved_image.gif";
    public static final String ATTRIBUTE_STYLE = "style";
    public static final String PARAMETER_POSITION = "position";
    public static final String PARAMETER_TOP = "top";
    public static final String PARAMETER_LEFT = "left";
    public static final String PARAMETER_WIDTH = "width";
    public static final String PARAMETER_HEIGHT = "height";
    public static final String PARAMETR_BACKGROND = "background";
    public static final String PARAMETR_VERTICAL_ALIGN = "vertical-align";
    public static final String VALUE_ABSOLUTE = "absolute";
    public static final String DOT_STRING = ".";
    public static final String COLON_STRING = ":";
    public static final String SEMICOLON_STRING = ";";
    public static final String PX_STRING = "px";
    public static final String SPACE_STRING = " ";
    public static final String EMPTY_STRING = "";
    public static final String SINGLE_QUOTE_STRING = "'";
    public static final String QUOTE_STRING = "\"";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final Pattern CSS_URL_PATTERN = Pattern.compile("(?<=\\burl\\b)(?:[\\p{Space}]*\\()[\\p{Space}]*([^;]*)[\\p{Space}]*(?:\\)[\\p{Space}]*)(?=(?>[^\\)]*;|[^\\)]*))");
    public static final Pattern CSS_IMPORT_PATTERN = Pattern.compile("@import[\\p{Space}]+(?:\\burl\\b[\\p{Space}]*\\()*[\\p{Space}]*([^;]*)[\\p{Space}]*(?:\\)[\\p{Space}]*(?=(?>[^\\)]*;|[^\\)]*)))*");
    public static final Pattern CSS_URI_PATTERN = Pattern.compile("(?:\\\"{1}(.*)\\\"{1})|(?:\\'{1}(.*)\\'{1})");
    public static String ATTR_URL = "url";
    public static String OPEN_BRACKET = "(";
    public static String CLOSE_BRACKET = ")";
    public static String FILE_PROTOCOL = "file:";
    public static String HTTP_PROTOCOL = "http:";
    public static String SLASH = "/";

    public static void setAbsolute(Element sourceElement) {
        String style = sourceElement.getAttribute(ATTRIBUTE_STYLE);
        style = style == null ? EMPTY_STRING : VpeStyleUtil.deleteFromString(style, PARAMETER_POSITION, SEMICOLON_STRING);
        if (style.length() > 0 && !style.endsWith(SEMICOLON_STRING)) {
            style = String.valueOf(style) + SEMICOLON_STRING;
        }
        style = String.valueOf(style) + " position : absolute;";
        sourceElement.setAttribute(ATTRIBUTE_STYLE, style);
    }

    public static String setAbsolute(String styleString) {
        String style = styleString;
        style = style == null ? EMPTY_STRING : VpeStyleUtil.deleteFromString(style, PARAMETER_POSITION, SEMICOLON_STRING);
        if (style.length() > 0 && !style.endsWith(SEMICOLON_STRING)) {
            style = String.valueOf(style) + SEMICOLON_STRING;
        }
        style = String.valueOf(style) + " position : absolute;";
        return style;
    }

    public static boolean getAbsolute(Element sourceElement) {
        String style = sourceElement.getAttribute(ATTRIBUTE_STYLE);
        if (style == null) {
            return false;
        }
        return style.indexOf(VALUE_ABSOLUTE) >= 0;
    }

    public static boolean getAbsolute(String style) {
        if (style == null) {
            return false;
        }
        return style.indexOf(VALUE_ABSOLUTE) >= 0;
    }

    public static int getSizeFromStyle(Element sourceElement, String sizeAttribute) {
        int endPosition;
        int valuePosition;
        int dotPosition = sizeAttribute.indexOf(DOT_STRING);
        String attribute = sizeAttribute.substring(0, dotPosition);
        String parameter = sizeAttribute.substring(dotPosition + 1, sizeAttribute.length());
        String style = sourceElement.getAttribute(attribute);
        if (style == null || EMPTY_STRING.equals(style)) {
            return -1;
        }
        int parameterPosition = style.indexOf(parameter);
        if (parameterPosition >= 0 && (valuePosition = style.indexOf(COLON_STRING, parameterPosition)) >= 0 && (endPosition = style.indexOf(PX_STRING, valuePosition)) >= 0) {
            return Integer.parseInt(style.substring(valuePosition + 1, endPosition).trim());
        }
        return -1;
    }

    public static String getParameterFromStyle(Element sourceElement, String sizeAttribute) {
        int endPosition;
        int valuePosition;
        int dotPosition = sizeAttribute.indexOf(DOT_STRING);
        String attribute = sizeAttribute.substring(0, dotPosition);
        String parameter = sizeAttribute.substring(dotPosition + 1, sizeAttribute.length());
        String style = sourceElement.getAttribute(attribute);
        if (style == null || EMPTY_STRING.equals(style)) {
            return null;
        }
        int parameterPosition = style.indexOf(parameter);
        if (parameterPosition >= 0 && (valuePosition = style.indexOf(COLON_STRING, parameterPosition)) >= 0 && (endPosition = style.indexOf(PX_STRING, valuePosition)) >= 0) {
            return style.substring(valuePosition + 1, endPosition).trim();
        }
        return null;
    }

    public static String getParameterFromStyleAttribute(String style, String parameter) {
        int valuePosition;
        if (style == null || EMPTY_STRING.equals(style)) {
            return null;
        }
        int parameterPosition = style.indexOf(parameter);
        if (parameterPosition >= 0 && (valuePosition = style.indexOf(COLON_STRING, parameterPosition)) >= 0) {
            int endPosition = style.indexOf(SEMICOLON_STRING, valuePosition);
            if (endPosition >= 0) {
                if ((endPosition = (style = style.substring(valuePosition + 1, endPosition).trim()).indexOf(PX_STRING, valuePosition)) >= 0) {
                    return style.substring(valuePosition + 1, endPosition).trim();
                }
                return style;
            }
            return style.substring(valuePosition + 1).trim();
        }
        return null;
    }

    public static void setParameterInStyle(Element sourceElement, String sizeAttribute, String value) {
        int dotPosition = sizeAttribute.indexOf(DOT_STRING);
        String attribute = sizeAttribute.substring(0, dotPosition);
        String parameter = sizeAttribute.substring(dotPosition + 1, sizeAttribute.length());
        String style = sourceElement.getAttribute(attribute);
        style = style == null ? EMPTY_STRING : VpeStyleUtil.deleteFromString(style, parameter, SEMICOLON_STRING);
        if (style.length() > 0 && !style.endsWith(SEMICOLON_STRING)) {
            style = String.valueOf(style) + SEMICOLON_STRING;
        }
        style = String.valueOf(style) + SPACE_STRING + parameter + SPACE_STRING + COLON_STRING + SPACE_STRING + value + SEMICOLON_STRING;
        sourceElement.setAttribute(attribute, style);
    }

    public static String setSizeInStyle(String style, String parameter, int size) {
        if ((style = style == null ? EMPTY_STRING : VpeStyleUtil.deleteFromString(style, parameter, SEMICOLON_STRING)).length() > 0 && !style.endsWith(SEMICOLON_STRING)) {
            style = String.valueOf(style) + SEMICOLON_STRING;
        }
        style = String.valueOf(style) + SPACE_STRING + parameter + SPACE_STRING + COLON_STRING + SPACE_STRING + size + PX_STRING + SEMICOLON_STRING;
        return style;
    }

    public static String setParameterInStyle(String style, String parameter, String value) {
        if ((style = style == null ? EMPTY_STRING : VpeStyleUtil.deleteFromString(style, parameter, SEMICOLON_STRING)).length() > 0 && !style.endsWith(SEMICOLON_STRING)) {
            style = String.valueOf(style) + SEMICOLON_STRING;
        }
        style = String.valueOf(style) + SPACE_STRING + parameter + SPACE_STRING + COLON_STRING + SPACE_STRING + value + SEMICOLON_STRING;
        return style;
    }

    public static String deleteFromString(String data, String begin, String end) {
        int startPosition = data.indexOf(begin);
        if (startPosition < 0) {
            return data;
        }
        int endPosition = data.indexOf(end, startPosition);
        String result = data.substring(0, startPosition).trim();
        if (endPosition > 0) {
            result = String.valueOf(result) + data.substring(endPosition + 1, data.length()).trim();
        }
        return result;
    }

    public static int cssSizeToInt(String sizeString) {
        int size = -1;
        if (sizeString != null && !EMPTY_STRING.equalsIgnoreCase(sizeString)) {
            int pxPosition = sizeString.indexOf(PX_STRING);
            if (pxPosition >= 0) {
                sizeString = sizeString.substring(0, pxPosition).trim();
            }
            try {
                size = Integer.parseInt(sizeString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return size;
    }
}

