/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.core.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class TransformUtil {
    private TransformUtil() {
    }

    public static Node getVisualNodeByVpvId(VpvVisualModel visualModel, String selectedElementId) throws XPathExpressionException {
        Document visualDocument = visualModel.getVisualDocument();
        XPath xPath = XPathFactory.newInstance().newXPath();
        String expression = "//*[@data-vpvid='" + selectedElementId + "']";
        Node node = (Node)xPath.compile(expression).evaluate(visualDocument, XPathConstants.NODE);
        return node;
    }

    public static Node getSourseNodeByVisualNode(VpvVisualModel visualModel, Node visualNode) {
        Map<Node, Node> sourceVisualMapping = visualModel.getSourceVisualMapping();
        for (Map.Entry<Node, Node> entry : sourceVisualMapping.entrySet()) {
            if (!entry.getValue().equals(visualNode)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static List<String> getAllMatches(String text, String regex) {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher m = Pattern.compile("(?=(" + regex + "))").matcher(text);
        while (m.find()) {
            matches.add(m.group(1));
        }
        Collections.sort(matches);
        return matches;
    }

    public static String getSelectedElementId(String text, String regex) {
        List<String> allMatches = TransformUtil.getAllMatches(text, regex);
        if (allMatches != null && !allMatches.isEmpty()) {
            return allMatches.get(allMatches.size() - 1);
        }
        return null;
    }
}

