/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.core.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.jboss.tools.vpe.preview.core.Activator;
import org.jboss.tools.vpe.preview.core.util.Messages;

public abstract class ActionBar {
    private static final String GROUP_REFRESH = "org.jboss.tools.vpv.refresh";
    private IAction refreshAction;
    private IAction goBackAction;
    private IAction goForwardAction;
    private IAction openInDefaultBrowserAction;
    private IAction enableAutomaticRefreshAction;
    private IAction enableRefreshOnSaveAction;
    private IExecutionListener saveListener;
    private Browser browser;
    private IPreferenceStore preferences;
    private Command saveCommand;
    private Command saveAllCommand;

    public ActionBar(Browser browser1, IPreferenceStore preferences) {
        this.browser = browser1;
        this.preferences = preferences;
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.saveCommand = commandService.getCommand("org.eclipse.ui.file.save");
        this.saveAllCommand = commandService.getCommand("org.eclipse.ui.file.saveAll");
        this.saveListener = new IExecutionListener(){

            public void postExecuteSuccess(String arg0, Object arg1) {
                ActionBar.this.refresh(ActionBar.this.browser);
            }

            public void notHandled(String arg0, NotHandledException arg1) {
            }

            public void postExecuteFailure(String arg0, ExecutionException arg1) {
            }

            public void preExecute(String arg0, ExecutionEvent arg1) {
            }
        };
    }

    public void fillLocalToolBar(IToolBarManager manager) {
        this.makeActions();
        manager.add(this.refreshAction);
        manager.add(this.goBackAction);
        manager.add(this.goForwardAction);
        manager.add(this.openInDefaultBrowserAction);
        manager.add((IContributionItem)new Separator(GROUP_REFRESH));
        manager.appendToGroup(GROUP_REFRESH, this.enableAutomaticRefreshAction);
        manager.appendToGroup(GROUP_REFRESH, this.enableRefreshOnSaveAction);
    }

    private void makeActions() {
        this.makeRefreshAction();
        this.makeGoBackAction();
        this.makeGoForwardAction();
        this.makeOpenInDefaultBrowserAction();
        this.makeEnableAutomaticRefreshAction();
        this.makeEnableRefreshOnSaveAction();
        this.enableAutomaticRefreshAction.run();
        this.enableRefreshOnSaveAction.run();
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.addTitleListener(new TitleListener(){

                public void changed(TitleEvent event) {
                    ActionBar.this.goBackAction.setEnabled(ActionBar.this.browser.isBackEnabled());
                    ActionBar.this.goForwardAction.setEnabled(ActionBar.this.browser.isForwardEnabled());
                }
            });
        }
    }

    protected abstract void refresh(Browser var1);

    private void makeEnableAutomaticRefreshAction() {
        this.enableAutomaticRefreshAction = new Action(Messages.VpvView_ENABLE_AUTOMATIC_REFRESH, 2){

            public void run() {
                if (ActionBar.this.enableAutomaticRefreshAction.isChecked()) {
                    ActionBar.this.enableRefreshOnSaveAction.setChecked(false);
                    ActionBar.this.saveCommand.removeExecutionListener(ActionBar.this.saveListener);
                    ActionBar.this.saveAllCommand.removeExecutionListener(ActionBar.this.saveListener);
                }
            }
        };
        this.enableAutomaticRefreshAction.setChecked(this.preferences.getBoolean("org.jboss.tools.vpe.enableRefreshOnChange"));
        this.enableAutomaticRefreshAction.setImageDescriptor(Activator.getImageDescriptor("icons/refresh_on_change.png"));
    }

    private void makeEnableRefreshOnSaveAction() {
        this.enableRefreshOnSaveAction = new Action(Messages.VpvView_ENABLE_REFRESH_ON_SAVE, 2){

            public void run() {
                if (ActionBar.this.enableRefreshOnSaveAction.isChecked()) {
                    ActionBar.this.saveCommand.addExecutionListener(ActionBar.this.saveListener);
                    ActionBar.this.saveAllCommand.addExecutionListener(ActionBar.this.saveListener);
                    ActionBar.this.enableAutomaticRefreshAction.setChecked(false);
                } else {
                    ActionBar.this.saveCommand.removeExecutionListener(ActionBar.this.saveListener);
                    ActionBar.this.saveAllCommand.removeExecutionListener(ActionBar.this.saveListener);
                }
            }
        };
        this.enableRefreshOnSaveAction.setChecked(this.preferences.getBoolean("org.jboss.tools.vpe.enableRefreshOnSave"));
        this.enableRefreshOnSaveAction.setImageDescriptor(Activator.getImageDescriptor("icons/refresh_on_save.png"));
    }

    private void makeOpenInDefaultBrowserAction() {
        this.openInDefaultBrowserAction = new Action(){

            public void run() {
                try {
                    URL url = new URL(ActionBar.this.browser.getUrl());
                    Program.launch((String)url.toString());
                }
                catch (MalformedURLException e) {
                    Activator.logError(e);
                }
            }
        };
        this.openInDefaultBrowserAction.setText(Messages.VpvView_OPEN_IN_DEFAULT_BROWSER);
        this.openInDefaultBrowserAction.setToolTipText(Messages.VpvView_OPEN_IN_DEFAULT_BROWSER);
        this.openInDefaultBrowserAction.setImageDescriptor(Activator.getImageDescriptor("icons/open_in_default_browser.gif"));
    }

    private void makeRefreshAction() {
        this.refreshAction = new Action(){

            public void run() {
                ActionBar.this.refresh(ActionBar.this.browser);
            }
        };
        this.refreshAction.setText(Messages.VpvView_REFRESH);
        this.refreshAction.setToolTipText(Messages.VpvView_REFRESH);
        this.refreshAction.setImageDescriptor(Activator.getImageDescriptor("icons/refresh.gif"));
    }

    private void makeGoBackAction() {
        this.goBackAction = new Action(){

            public void run() {
                if (ActionBar.this.browser.isBackEnabled()) {
                    ActionBar.this.browser.back();
                }
            }
        };
        this.goBackAction.setText(Messages.VpvView_BACK);
        this.goBackAction.setToolTipText(Messages.VpvView_BACK);
        this.goBackAction.setImageDescriptor(Activator.getImageDescriptor("icons/nav_backward.gif"));
    }

    private void makeGoForwardAction() {
        this.goForwardAction = new Action(){

            public void run() {
                if (ActionBar.this.browser.isForwardEnabled()) {
                    ActionBar.this.browser.forward();
                }
            }
        };
        this.goForwardAction.setText(Messages.VpvView_FORWARD);
        this.goForwardAction.setToolTipText(Messages.VpvView_FORWARD);
        this.goForwardAction.setImageDescriptor(Activator.getImageDescriptor("icons/nav_forward.gif"));
    }

    public boolean isAutomaticRefreshEnabled() {
        return this.enableAutomaticRefreshAction.isChecked();
    }

    public void updateRefreshItemsAccordingToPreferences() {
        this.enableRefreshOnSaveAction.setChecked(this.preferences.getBoolean("org.jboss.tools.vpe.enableRefreshOnSave"));
        this.enableRefreshOnSaveAction.run();
        this.enableAutomaticRefreshAction.setChecked(this.preferences.getBoolean("org.jboss.tools.vpe.enableRefreshOnChange"));
        this.enableAutomaticRefreshAction.run();
    }

    public void dispose() {
        this.saveCommand.removeExecutionListener(this.saveListener);
        this.saveAllCommand.removeExecutionListener(this.saveListener);
        this.preferences.setValue("org.jboss.tools.vpe.enableRefreshOnChange", this.enableAutomaticRefreshAction.isChecked());
        this.preferences.setValue("org.jboss.tools.vpe.enableRefreshOnSave", this.enableRefreshOnSaveAction.isChecked());
    }
}

