/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;
import org.jboss.tools.vpe.preview.Messages;
import org.jboss.tools.vpe.preview.core.server.VpvServer;
import org.jboss.tools.vpe.preview.core.transform.VpvController;
import org.jboss.tools.vpe.preview.core.transform.VpvDomBuilder;
import org.jboss.tools.vpe.preview.core.transform.VpvTemplateProvider;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModelHolderRegistry;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.vpe.preview";
    private static final String PREVIEW_EVENT_ACTION = "preview";
    private static Activator plugin;
    private VpvServer server;
    private VpvVisualModelHolderRegistry visualModelHolderRegistry;
    private VpvDomBuilder domBuilder;
    private UsageEventType previewEventType;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        VpvTemplateProvider templateProvider = new VpvTemplateProvider();
        this.domBuilder = new VpvDomBuilder(templateProvider);
        this.visualModelHolderRegistry = new VpvVisualModelHolderRegistry();
        VpvController vpvController = new VpvController(this.domBuilder, this.visualModelHolderRegistry);
        this.server = new VpvServer(vpvController);
        this.previewEventType = new UsageEventType((Plugin)this, PREVIEW_EVENT_ACTION, Messages.UsageEventTypePreviewLabelDescription, UsageEventType.HOW_MANY_TIMES_VALUE_DESCRIPTION);
        UsageReporter.getInstance().registerEvent(this.previewEventType);
    }

    public UsageEventType getPreviewEventType() {
        return this.previewEventType;
    }

    public void stop(BundleContext context) throws Exception {
        this.server.stop();
        this.server = null;
        this.visualModelHolderRegistry = null;
        this.domBuilder = null;
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public VpvVisualModelHolderRegistry getVisualModelHolderRegistry() {
        return this.visualModelHolderRegistry;
    }

    public VpvDomBuilder getDomBuilder() {
        return this.domBuilder;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static URL getFileUrl(String path) {
        return plugin.getBundle().getEntry(path);
    }

    public VpvServer getServer() {
        return this.server;
    }

    public static void logError(Throwable e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), e));
    }

    public static void logInfo(String info) {
        Activator.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, info));
    }
}

