/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.xulrunner.util;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.jboss.tools.vpe.xulrunner.BrowserPlugin;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMClientRect;
import org.mozilla.interfaces.nsIDOMClientRectList;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMElementCSSInlineStyle;
import org.mozilla.interfaces.nsIDOMHTMLDocument;
import org.mozilla.interfaces.nsIDOMHTMLElement;
import org.mozilla.interfaces.nsIDOMNSElement;
import org.mozilla.interfaces.nsIDOMNSHTMLElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.XPCOMException;

public class XulRunnerVpeUtils {
    public static nsIDOMElement getRootElement(nsIDOMDocument domDocument) {
        nsIDOMHTMLElement htmlBody;
        nsIDOMElement bodyElement = null;
        nsIDOMHTMLDocument htmlDocument = XPCOM.queryInterface((nsISupports)domDocument, nsIDOMHTMLDocument.class);
        if (htmlDocument != null && (htmlBody = htmlDocument.getBody()) != null) {
            bodyElement = XPCOM.queryInterface((nsISupports)htmlBody, nsIDOMElement.class);
        }
        return bodyElement;
    }

    public static void setElementPosition(nsIDOMElement domElement, int left, int top) {
        XulRunnerVpeUtils.setStylePropertyPixels(domElement, "left", left);
        XulRunnerVpeUtils.setStylePropertyPixels(domElement, "top", top);
    }

    public static void setElementSize(nsIDOMElement domElement, int width, int height) {
        XulRunnerVpeUtils.setStylePropertyPixels(domElement, "width", width);
        XulRunnerVpeUtils.setStylePropertyPixels(domElement, "height", height);
    }

    public static void setElementBounds(nsIDOMElement domElement, Rectangle bounds) {
        XulRunnerVpeUtils.setElementPosition(domElement, bounds.x, bounds.y);
        XulRunnerVpeUtils.setElementSize(domElement, bounds.width, bounds.height);
    }

    public static void setStylePropertyPixels(nsIDOMElement aElement, String aProperty, int aValue) {
        XulRunnerVpeUtils.setStyle(aElement, aProperty, String.valueOf(aValue) + "px");
    }

    public static void setStyle(nsIDOMElement domElement, String cssPropertyName, String cssPropertyValue) {
        nsIDOMElementCSSInlineStyle inlineStyles = XPCOM.queryInterface((nsISupports)domElement, nsIDOMElementCSSInlineStyle.class);
        if (inlineStyles == null) {
            return;
        }
        nsIDOMCSSStyleDeclaration cssDecl = inlineStyles.getStyle();
        if (cssDecl == null) {
            return;
        }
        if (cssPropertyValue.length() == 0) {
            cssDecl.removeProperty(cssPropertyName);
        } else {
            String priority = cssDecl.getPropertyPriority(cssPropertyName);
            cssDecl.setProperty(cssPropertyName, cssPropertyValue, priority);
        }
    }

    public static nsIDOMElement createAnonymousElement(nsIDOMDocument domDocument, String aTag, nsIDOMNode aParentNode, String aAnonClass, boolean isCreatedHidden) {
        nsIDOMElement element = null;
        element = domDocument.createElement(aTag);
        if (isCreatedHidden) {
            element.setAttribute("class", "hidden");
        }
        if (aAnonClass.length() != 0) {
            element.setAttribute("_moz_anonclass", aAnonClass);
        }
        aParentNode.appendChild((nsIDOMNode)element);
        return element;
    }

    public static Point getVisualNodeOffset(nsIDOMNode node) {
        Point p = new Point(-1, -1);
        try {
            p = XulRunnerVpeUtils.getDocumentPos(XPCOM.queryInterface((nsISupports)node, nsIDOMNSHTMLElement.class));
        }
        catch (XPCOMException xPCOMException) {
            // empty catch block
        }
        return p;
    }

    private static Point getDocumentPos(nsIDOMNSHTMLElement boxElement) {
        int x = 0;
        int y = 0;
        nsIDOMNSHTMLElement curBoxElement = boxElement;
        while (curBoxElement != null) {
            x += curBoxElement.getOffsetLeft();
            y += curBoxElement.getOffsetTop();
            curBoxElement = XulRunnerVpeUtils.getOffsetParent(curBoxElement);
        }
        return new Point(x, y);
    }

    private static nsIDOMNSHTMLElement getOffsetParent(nsIDOMNSHTMLElement boxElement) {
        nsIDOMElement offsetParent = boxElement.getOffsetParent();
        if (offsetParent != null) {
            return XPCOM.queryInterface((nsISupports)offsetParent, nsIDOMNSHTMLElement.class);
        }
        return null;
    }

    private static Point getClientSize(nsIDOMNSElement element) {
        int width = 0;
        int height = 0;
        nsIDOMClientRectList clientRects = element.getClientRects();
        if (clientRects.getLength() > 0L) {
            nsIDOMClientRect firstRect = clientRects.item(0L);
            width = (int)firstRect.getWidth();
            height = (int)firstRect.getHeight();
        }
        return new Point(width, height);
    }

    public static Rectangle getElementBounds(nsIDOMNode node) {
        try {
            nsIDOMNSElement element = XPCOM.queryInterface((nsISupports)node, nsIDOMNSElement.class);
            nsIDOMNSHTMLElement htmlElement = XPCOM.queryInterface((nsISupports)node, nsIDOMNSHTMLElement.class);
            Point documentPos = XulRunnerVpeUtils.getDocumentPos(htmlElement);
            Point clientSize = XulRunnerVpeUtils.getClientSize(element);
            Rectangle rectangle = new Rectangle(documentPos.x, documentPos.y, clientSize.x, clientSize.y);
            if (BrowserPlugin.PRINT_ELEMENT_BOUNDS) {
                System.out.println("getElementBounds(IDOMNode) returns " + rectangle);
                System.out.println("nsIDOMNSHTMLElement getOffsetLeft,getOffsetTop,getOffsetWidth,getOffsetHeight" + new Rectangle(htmlElement.getOffsetLeft(), htmlElement.getOffsetTop(), htmlElement.getOffsetWidth(), htmlElement.getOffsetHeight()));
                System.out.println("nsIDOMNSElement getClientLeft,getClientTop,getClientWidth,getClientHeight" + new Rectangle(element.getClientLeft(), element.getClientTop(), element.getClientWidth(), element.getClientHeight()));
            }
            return rectangle;
        }
        catch (XPCOMException xpcomException) {
            return new Rectangle(0, 0, 0, 0);
        }
    }

    public static Rectangle getTextSelectionBounds(nsIDOMText selectionContainer) {
        return new Rectangle(0, 0, 0, 0);
    }
}

