/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.jst.web.ui.internal.editor.bundle.BundleMap;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualContext;
import org.jboss.tools.jst.web.ui.internal.editor.preferences.VpePreference;
import org.jboss.tools.vpe.editor.VpeEditorPart;
import org.jboss.tools.vpe.editor.VpeIncludeInfo;
import org.jboss.tools.vpe.editor.VpeSourceDomBuilder;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.AbstractPageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.util.ElService;
import org.jboss.tools.vpe.editor.util.ElServiceUtil;
import org.jboss.tools.vpe.editor.util.XmlUtil;
import org.jboss.tools.vpe.resref.core.AbsoluteFolderReferenceList;
import org.jboss.tools.vpe.resref.core.RelativeFolderReferenceList;
import org.jboss.tools.vpe.resref.core.TaglibReferenceList;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpePageContext
extends AbstractPageContext
implements IVisualContext {
    private VpeEditorPart editPart;
    private VpeSourceDomBuilder sourceBuilder;
    private VpeVisualDomBuilder visualBuilder;
    protected Map<String, Object> values = new HashMap<String, Object>();

    public VpePageContext(BundleMap bundle, VpeEditorPart editPart) {
        this.bundle = bundle;
        this.editPart = editPart;
        this.resetElService();
    }

    public void resetElService() {
        this.setElService(new ElService(this));
    }

    public VpeSourceDomBuilder getSourceBuilder() {
        return this.sourceBuilder;
    }

    public static boolean isAbsolutePosition() {
        return "yes".equals(VpePreference.USE_ABSOLUTE_POSITION.getValue());
    }

    public void addAttributeInCustomElementsMap(String key, String value) {
        this.getCustomElementsAttributes().put(key, value);
    }

    public void removeAttributeFromCustomElementsMap(String key) {
        this.getCustomElementsAttributes().remove(key);
    }

    public boolean containsAttributeInCustomElementsMap(String key) {
        return this.getCustomElementsAttributes().containsKey(key);
    }

    public String getAttributefromCustomElementsMapValue(String key) {
        return this.getCustomElementsAttributes().get(key);
    }

    public Set<String> getKeysCustomElementsAttributes() {
        return new HashSet<String>(this.getCustomElementsAttributes().keySet());
    }

    public void clearCustomElementAttributesMap() {
        this.getCustomElementsAttributes().clear();
    }

    public void setSourceDomBuilder(VpeSourceDomBuilder sourceBuilder) {
        this.sourceBuilder = sourceBuilder;
        this.refreshConnector();
    }

    public void refreshConnector() {
    }

    public VpeVisualDomBuilder getVisualBuilder() {
        return this.visualBuilder;
    }

    public void setVisualDomBuilder(VpeVisualDomBuilder visualBuilder) {
        this.visualBuilder = visualBuilder;
    }

    public void refreshResReferences() {
        VpeIncludeInfo vii;
        if (this.visualBuilder != null && (vii = this.visualBuilder.getCurrentIncludeInfo()) != null && vii.getStorage() instanceof IFile) {
            IFile file = (IFile)vii.getStorage();
            ResourceReference[] rr = ElServiceUtil.getAllResources(file);
            rr = ElServiceUtil.sortReferencesByScope2(rr);
            this.putValue("resourceReferences", rr);
        }
    }

    public VpeDomMapping getDomMapping() {
        return this.visualBuilder.getDomMapping();
    }

    public void clearAll() {
        this.bundle.clearAll();
        this.clearValues();
    }

    public void dispose() {
        this.bundle.dispose();
        this.clearAll();
        this.editPart = null;
        this.sourceBuilder = null;
        this.visualBuilder = null;
    }

    @Override
    public BundleMap getBundle() {
        return this.bundle;
    }

    @Override
    public void refreshBundleValues() {
        if (this.getVisualBuilder() == null) {
            return;
        }
        List<Node> nodes = this.getVisualBuilder().getSourceNodes();
        for (Node node : nodes) {
            if (!(node instanceof Element)) continue;
            Element sourceElement = (Element)node;
            this.visualBuilder.refreshBundleValues(sourceElement);
        }
    }

    public boolean isCorrectNS(Node sourceNode) {
        String sourcePrefix = sourceNode.getPrefix();
        if (sourcePrefix == null || ((ElementImpl)sourceNode).isJSPTag()) {
            return true;
        }
        List<TaglibData> taglibs = XmlUtil.getTaglibsForNode(sourceNode, this);
        TaglibData sourceNodeTaglib = XmlUtil.getTaglibForPrefix(sourcePrefix, taglibs);
        return sourceNodeTaglib != null;
    }

    public String getSourceTaglibUri(Node sourceNode) {
        String sourcePrefix = sourceNode.getPrefix();
        if (sourcePrefix == null || ((ElementImpl)sourceNode).isJSPTag()) {
            return null;
        }
        List<TaglibData> taglibs = XmlUtil.getTaglibsForNode(sourceNode, this);
        TaglibData sourceNodeTaglib = XmlUtil.getTaglibForPrefix(sourcePrefix, taglibs);
        if (sourceNodeTaglib == null) {
            return null;
        }
        String sourceNodeUri = sourceNodeTaglib.getUri();
        return sourceNodeUri;
    }

    @Override
    public VpeEditorPart getEditPart() {
        return this.editPart;
    }

    @Override
    public List<TaglibData> getIncludeTaglibs() {
        if (this.getEditPart() == null) {
            return new ArrayList<TaglibData>();
        }
        IEditorInput input = this.getEditPart().getEditorInput();
        IFile file = null;
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        }
        ResourceReference[] resourceReferences = new ResourceReference[]{};
        if (file != null) {
            resourceReferences = TaglibReferenceList.getInstance().getAllResources(file);
        }
        ArrayList<TaglibData> taglibData = new ArrayList<TaglibData>();
        ResourceReference[] resourceReferenceArray = resourceReferences;
        int n = resourceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceReference resourceReference = resourceReferenceArray[n2];
            taglibData.add(new TaglibData(0, resourceReference.getLocation(), resourceReference.getProperties()));
            ++n2;
        }
        return taglibData;
    }

    public ResourceReference getRuntimeRelativeFolder(IFile file) {
        ResourceReference[] list = RelativeFolderReferenceList.getInstance().getAllResources(file);
        if (list.length > 0) {
            return list[list.length - 1];
        }
        return null;
    }

    public ResourceReference getRuntimeAbsoluteFolder(IFile file) {
        ResourceReference[] list = AbsoluteFolderReferenceList.getInstance().getAllResources(file);
        if (list.length > 0) {
            return list[list.length - 1];
        }
        return null;
    }

    public List<TaglibData> getTagLibs(Node sourceNode) {
        return XmlUtil.getTaglibsForNode(sourceNode, this);
    }

    public nsIDOMNode getCurrentVisualNode() {
        return (nsIDOMNode)this.getValue("currentVisualNode");
    }

    public void setCurrentVisualNode(nsIDOMNode currentVisualNode) {
        this.putValue("currentVisualNode", currentVisualNode);
    }

    public ElService getElService() {
        return (ElService)this.getValue("elExprService");
    }

    public void setElService(ElService elService) {
        this.putValue("elExprService", elService);
    }

    public static void processDisplayEvents() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display != null) {
            while (display.readAndDispatch()) {
            }
        }
    }

    protected Map<String, String> getCustomElementsAttributes() {
        HashMap<String, String> res = null;
        Object obj = this.values.get("customElementsAttributes");
        if (obj == null || !(obj instanceof HashMap)) {
            res = new HashMap();
            this.values.put("customElementsAttributes", res);
        } else {
            res = (Map)obj;
        }
        return res;
    }

    public boolean putValue(String key, Object val) {
        boolean res = !this.values.containsKey(key);
        this.values.put(key, val);
        return res;
    }

    public Object removeValue(String key) {
        return this.values.remove(key);
    }

    public Object getValue(String key) {
        return this.values.get(key);
    }

    public void clearValues() {
        this.values.clear();
    }

    public String[] getValueNames() {
        return this.values.keySet().toArray(new String[0]);
    }
}

