/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.menu.action;

import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.JSPPaletteInsertHelper;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.util.SelectionUtil;

@Deprecated
public class InsertAction
extends Action {
    private XModelObject item;
    private Point region;
    private VpePageContext pageContext;
    private StructuredTextEditor sourceEditor;
    private boolean replace;

    public InsertAction(String title, Point region, XModelObject item, VpePageContext pageContext, StructuredTextEditor sourceEditor) {
        this(title, region, item, pageContext, sourceEditor, false);
    }

    public InsertAction(String title, Point region, XModelObject item, VpePageContext pageContext, StructuredTextEditor sourceEditor, boolean replace) {
        super(title);
        this.item = item;
        this.region = region;
        this.pageContext = pageContext;
        this.sourceEditor = sourceEditor;
        this.replace = replace;
    }

    public void run() {
        IUndoManager undoManager = this.sourceEditor.getTextViewer().getUndoManager();
        try {
            undoManager.beginCompoundChange();
            this.insert();
        }
        finally {
            undoManager.endCompoundChange();
        }
    }

    private void insert() {
        String tagName = this.item.getAttributeValue("name");
        XModelObject parent = this.item.getParent();
        String uri = parent == null ? "" : parent.getAttributeValue("library uri");
        String libraryVersion = parent == null ? "" : parent.getAttributeValue("library version");
        String defaultPrefix = parent == null ? "" : parent.getAttributeValue("default prefix");
        String startText = this.item.getAttributeValue("start text");
        String endText = this.item.getAttributeValue("end text");
        if (this.region != null) {
            if (this.replace) {
                this.getSourceEditor().getTextViewer().getTextWidget().replaceTextRange(this.region.x, this.region.y, "");
            } else {
                SelectionUtil.setSourceSelection(this.pageContext, this.region.x, this.region.y);
            }
        }
        ISelectionProvider selProvider = this.sourceEditor.getSelectionProvider();
        Properties p = new Properties();
        p.setProperty("tag name", tagName);
        p.setProperty("start text", startText);
        p.setProperty("end text", endText);
        p.setProperty("automatically reformat tag body", this.item.getAttributeValue("automatically reformat tag body"));
        p.setProperty("library uri", uri);
        p.setProperty("library version", libraryVersion);
        String addTaglib = this.item.getParent().getAttributeValue("add taglib");
        p.setProperty("default prefix", defaultPrefix);
        p.setProperty("add taglib", addTaglib);
        p.put("selectionProvider", selProvider);
        JSPPaletteInsertHelper.getInstance().insertIntoEditor((ISourceViewer)this.sourceEditor.getTextViewer(), p);
    }

    protected VpePageContext getPageContext() {
        return this.pageContext;
    }

    protected StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }
}

