/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.menu.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IUndoManager;
import org.jboss.tools.vpe.editor.menu.VpeMenuUtil;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StripTagAction
extends Action {
    final Node node;
    final VpeMenuUtil menuUtil = new VpeMenuUtil();

    public StripTagAction() {
        this.node = this.menuUtil.getSelectedNode();
        this.init();
    }

    public StripTagAction(Node node) {
        this.node = node;
        this.init();
    }

    private void init() {
        this.setText(VpeUIMessages.STRIP_TAG_MENU_ITEM);
    }

    public void run() {
        Node parent = this.node.getParentNode();
        if (parent != null) {
            IUndoManager undoManager = this.menuUtil.getSourceEditor().getTextViewer().getUndoManager();
            try {
                undoManager.beginCompoundChange();
                this.moveNodeChildrenInto(parent);
                parent.removeChild(this.node);
            }
            finally {
                undoManager.endCompoundChange();
            }
        }
    }

    private void moveNodeChildrenInto(Node parent) {
        NodeList children = this.node.getChildNodes();
        int childrenLength = children.getLength();
        int i = 0;
        while (i < childrenLength) {
            Node child = children.item(0);
            this.node.removeChild(child);
            parent.insertBefore(child, this.node);
            ++i;
        }
    }

    public boolean isEnabled() {
        return this.node != null && this.node.getNodeType() == 1;
    }
}

