/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.jst.web.ui.internal.editor.util.NodesManagingUtil;
import org.jboss.tools.vpe.editor.VpeIncludeInfo;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeCreatorUtil;
import org.jboss.tools.vpe.editor.template.VpeIncludeTemplate;
import org.jboss.tools.vpe.editor.template.custom.CustomTLDReference;
import org.jboss.tools.vpe.editor.template.custom.VpeCustomStringStorage;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class VpeCustomTemplate
extends VpeIncludeTemplate {
    @Override
    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        IStorage sourceFileStorage = this.getCustomTemplateStorage(pageContext, sourceNode);
        if (sourceFileStorage instanceof IFile) {
            IFile file = (IFile)sourceFileStorage;
            if (file.exists() && !pageContext.getVisualBuilder().isFileInIncludeStack((IStorage)file)) {
                Document document = pageContext.getVisualBuilder().getIncludeDocuments().get(file);
                if (document == null && (document = VpeCreatorUtil.getDocumentForRead(file)) != null) {
                    pageContext.getVisualBuilder().getIncludeDocuments().put((IStorage)file, document);
                }
                if (document != null) {
                    return this.createCreationData(pageContext, sourceNode, (IStorage)file, document, visualDocument);
                }
            }
        } else if (sourceFileStorage instanceof VpeCustomStringStorage) {
            VpeCustomStringStorage customStringStorage = (VpeCustomStringStorage)sourceFileStorage;
            if (!pageContext.getVisualBuilder().isFileInIncludeStack(customStringStorage)) {
                Document document = pageContext.getVisualBuilder().getIncludeDocuments().get(customStringStorage);
                if (document == null && (document = VpeCreatorUtil.getDocumentForRead(customStringStorage.getContentString())) != null) {
                    pageContext.getVisualBuilder().getIncludeDocuments().put(customStringStorage, document);
                }
                if (document != null) {
                    return this.createCreationData(pageContext, sourceNode, customStringStorage, document, visualDocument);
                }
            }
        }
        VpeCreationData creationData = this.createStub(sourceNode.getNodeName(), visualDocument);
        creationData.setData(null);
        return creationData;
    }

    private VpeCreationData createCreationData(VpePageContext pageContext, Node sourceNode, IStorage storage, Document document, nsIDOMDocument visualDocument) {
        VpeCreationData creationData = this.createInclude(document, visualDocument);
        this.addAttributesToELExcpressions(sourceNode, pageContext);
        creationData.setData(storage);
        pageContext.getVisualBuilder().pushIncludeStack(new VpeIncludeInfo((Element)sourceNode, storage, document));
        return creationData;
    }

    @Override
    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        pageContext.clearCustomElementAttributesMap();
        super.validate(pageContext, sourceNode, visualDocument, data);
    }

    protected void addAttributesToELExcpressions(Node sourceNode, VpePageContext vpePageContext) {
        NamedNodeMap attributesMap = sourceNode.getAttributes();
        int i = 0;
        while (i < attributesMap.getLength()) {
            Attr attr = (Attr)attributesMap.item(i);
            vpePageContext.addAttributeInCustomElementsMap(attr.getName(), attr.getValue());
            ++i;
        }
    }

    @Override
    public void beforeRemove(VpePageContext pageContext, Node sourceNode, nsIDOMNode visualNode, Object data) {
        IFile file = null;
        if (data instanceof IFile) {
            file = (IFile)data;
        }
        super.beforeRemove(pageContext, sourceNode, visualNode, file);
    }

    @Override
    public IRegion getSourceRegionForOpenOn(VpePageContext pageContext, Node sourceNode, nsIDOMNode domNode) {
        int offset = NodesManagingUtil.getStartOffsetNode((Node)sourceNode);
        return new Region(offset += sourceNode.getPrefix().length() + 1 + 1, 0);
    }

    protected IStorage getCustomTemplateStorage(VpePageContext pageContext, Node sourceNode) {
        return CustomTLDReference.getCustomElementStorage(sourceNode, pageContext);
    }
}

