/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template.expression;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageProcessor;
import org.jboss.tools.jst.web.kb.internal.proposal.CustomProposalType;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibAttribute;
import org.jboss.tools.jst.web.kb.taglib.IAttribute;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.computers.JspELCompletionProposalComputer;
import org.jboss.tools.jst.web.ui.internal.editor.outline.ValueHelper;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeCreatorUtil;
import org.jboss.tools.vpe.editor.template.expression.VpeAttributeOperand;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeFunction;
import org.jboss.tools.vpe.editor.template.expression.VpeValue;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.w3c.dom.Node;

public class VpeFunctionSrc
extends VpeFunction {
    static final String IMG_UNRESOLVED = "unresolved_image.gif";
    static final String IMG_PREFIX = "file:///";

    @Override
    public VpeValue exec(VpePageContext pageContext, Node sourceNode) throws VpeExpressionException {
        String device;
        String tagValue = this.getParameter(0).exec(pageContext, sourceNode).stringValue();
        IFile iFile = VpeCreatorUtil.getFile(tagValue, pageContext);
        if (iFile != null) {
            return new VpeValue(String.valueOf(this.getPrefix()) + iFile.getLocation().toString());
        }
        tagValue = this.processValue(pageContext, sourceNode, tagValue);
        try {
            tagValue = URLDecoder.decode(tagValue, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalArgumentException ex) {
            tagValue = "";
        }
        Path tagPath = new Path(tagValue);
        if (tagPath.isEmpty()) {
            return new VpeValue(this.getUnresolved());
        }
        String string = device = tagPath.getDevice() == null ? tagPath.segment(0) : tagPath.getDevice();
        if (device != null && ("http:".equalsIgnoreCase(device) || "file:".equalsIgnoreCase(device))) {
            return new VpeValue(tagValue);
        }
        File locFile = tagPath.toFile();
        if (locFile.exists()) {
            return new VpeValue(String.valueOf(this.getPrefix()) + tagPath.toString());
        }
        IEditorInput input = pageContext.getEditPart().getEditorInput();
        IPath imgPath = VpeStyleUtil.toFullPath(pageContext, (IPath)tagPath);
        if (imgPath != null && imgPath.toFile().exists()) {
            return new VpeValue(String.valueOf(this.getPrefix()) + imgPath.toString());
        }
        IFile file = null;
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        }
        if (file != null) {
            File f;
            ResourceReference resourceReference = null;
            if ("/".equals(tagValue.substring(0, 1))) {
                resourceReference = pageContext.getRuntimeAbsoluteFolder(file);
                tagValue = tagValue.substring(1);
            } else {
                resourceReference = pageContext.getRuntimeRelativeFolder(file);
            }
            String location = null;
            if (resourceReference != null) {
                location = resourceReference.getLocation();
            }
            if (location == null && file.getLocation() != null) {
                location = file.getLocation().toFile().getParent();
            }
            if (location != null && (f = new File(String.valueOf(location) + File.separator + tagValue)).exists()) {
                return new VpeValue(String.valueOf(this.getPrefix()) + f.getPath());
            }
        }
        return new VpeValue(this.getUnresolved());
    }

    protected IPath getInputParentPath(IEditorInput input) {
        IFile inputFile;
        IPath inputPath = null;
        if (input instanceof ILocationProvider) {
            inputPath = ((ILocationProvider)input).getPath((Object)input);
        } else if (input instanceof IFileEditorInput && (inputFile = ((IFileEditorInput)input).getFile()) != null) {
            inputPath = inputFile.getLocation();
        }
        if (inputPath != null && !inputPath.isEmpty()) {
            inputPath = inputPath.removeLastSegments(1);
        }
        return inputPath;
    }

    protected String getUnresolved() {
        return VpeStyleUtil.getAbsoluteResourcePathUrl(IMG_UNRESOLVED);
    }

    protected String getPrefix() {
        return String.valueOf(VpeStyleUtil.FILE_PROTOCOL) + VpeStyleUtil.SLASH + VpeStyleUtil.SLASH + VpeStyleUtil.SLASH;
    }

    private String processValue(VpePageContext pageContext, Node sourceNode, String tagValue) throws VpeExpressionException {
        String attrName = null;
        if (this.getParameter(0) instanceof VpeAttributeOperand) {
            attrName = ((VpeAttributeOperand)this.getParameter(0)).getAttributeName();
        }
        String query = attrName == null ? null : "/" + sourceNode.getNodeName() + "@" + attrName;
        IDocument document = pageContext.getSourceBuilder().getStructuredTextViewer().getDocument();
        if (document == null || query == null) {
            return tagValue;
        }
        final IEditorPart editor = pageContext.getEditPart().getSite().getPage().getActiveEditor();
        ValueHelper valueHelper = new ValueHelper(){

            protected IEditorPart getEditor() {
                return editor;
            }
        };
        JspELCompletionProposalComputer processor = valueHelper.createContentAssistProcessor();
        int offset = 0;
        if (sourceNode instanceof IndexedRegion) {
            offset = ((IndexedRegion)sourceNode).getStartOffset() + 1;
        }
        IPageContext pc = valueHelper.createPageContext(processor, offset);
        KbQuery kbQuery = this.createKbQuery(processor, sourceNode, offset, attrName);
        IAttribute[] as = PageProcessor.getInstance().getAttributes(kbQuery, pc);
        CustomTagLibAttribute a = null;
        IAttribute[] iAttributeArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute i = iAttributeArray[n2];
            if (i instanceof CustomTagLibAttribute) {
                a = (CustomTagLibAttribute)i;
                break;
            }
            ++n2;
        }
        if (a != null) {
            CustomProposalType[] ds = a.getProposals();
            int i = 0;
            while (i < ds.length) {
                if ("file".equals(ds[i].getType())) {
                    CustomProposalType.Param[] ps;
                    CustomProposalType.Param[] paramArray = ps = ds[i].getParams();
                    int n3 = ps.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String v;
                        CustomProposalType.Param p = paramArray[n4];
                        if ("pathAddition".equals(p.getName()) && (v = p.getValue()) != null && v.length() > 0 && tagValue.startsWith(v)) {
                            tagValue = tagValue.substring(v.length());
                        }
                        ++n4;
                    }
                }
                ++i;
            }
        }
        return tagValue;
    }

    protected KbQuery createKbQuery(JspELCompletionProposalComputer processor, Node fNode, int offset, String attrName) {
        KbQuery kbQuery = new KbQuery();
        String[] parentTags = processor.getParentTags(false);
        parentTags = this.add(parentTags, fNode.getNodeName());
        String prefix = this.getPrefix(fNode);
        kbQuery.setPrefix(prefix);
        kbQuery.setUri(processor.getUri(prefix));
        kbQuery.setParentTags(parentTags);
        kbQuery.setParent(fNode.getNodeName());
        kbQuery.setMask(false);
        kbQuery.setType(KbQuery.Type.ATTRIBUTE_NAME);
        kbQuery.setOffset(offset);
        kbQuery.setValue(attrName);
        kbQuery.setStringQuery(attrName);
        return kbQuery;
    }

    private String[] add(String[] result, String v) {
        String[] result1 = new String[result.length + 1];
        System.arraycopy(result, 0, result1, 0, result.length);
        result1[result.length] = v;
        return result1;
    }

    private String getPrefix(Node fNode) {
        int i = fNode.getNodeName().indexOf(58);
        return i < 0 ? null : fNode.getNodeName().substring(0, i);
    }
}

