/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template.resize;

import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeTagDescription;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionInfo;
import org.jboss.tools.vpe.editor.template.expression.VpeValue;
import org.jboss.tools.vpe.editor.template.resize.TemplateResizeData;
import org.jboss.tools.vpe.editor.util.SourceDomUtil;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeResizer {
    private static final String TAG_WIDTH = "vpe:width";
    private static final String TAG_HEIGHT = "vpe:height";
    private static final String ATTRIBUTE_WIDTH = "width-attr";
    private static final String ATTRIBUTE_HEIGHT = "height-attr";
    private static final String ATTRIBUTE_TAG_XPATH = "tag-xpath";
    private static final String ATTRIBUTE_TEST = "test";
    private static final String ATTRIBUTE_DISABLE_ABSOLUTE_POSITION = "disable-absolute-position";
    private TemplateResizeData horizontalData;
    private TemplateResizeData verticalData;

    public void setResizeData(Element node) {
        TemplateResizeData resizeWidth = null;
        TemplateResizeData resizeHeight = null;
        NodeList children = node.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            int i = 0;
            while (i < len) {
                String name;
                Node innerNode = children.item(i);
                if (innerNode.getNodeType() == 1 && (name = innerNode.getNodeName()).startsWith("vpe:")) {
                    if (TAG_WIDTH.equals(name)) {
                        if (this.horizontalData == null) {
                            resizeWidth = this.horizontalData = new TemplateResizeData(((Element)innerNode).getAttribute(ATTRIBUTE_WIDTH), "left", ((Element)innerNode).getAttribute(ATTRIBUTE_TAG_XPATH), ((Element)innerNode).getAttribute(ATTRIBUTE_TEST), ((Element)innerNode).getAttribute(ATTRIBUTE_DISABLE_ABSOLUTE_POSITION));
                        } else {
                            resizeWidth.setNext(new TemplateResizeData(((Element)innerNode).getAttribute(ATTRIBUTE_WIDTH), "left", ((Element)innerNode).getAttribute(ATTRIBUTE_TAG_XPATH), ((Element)innerNode).getAttribute(ATTRIBUTE_TEST), ((Element)innerNode).getAttribute(ATTRIBUTE_DISABLE_ABSOLUTE_POSITION)));
                            resizeWidth = resizeWidth.getNext();
                        }
                    } else if (TAG_HEIGHT.equals(name)) {
                        if (this.verticalData == null) {
                            resizeHeight = this.verticalData = new TemplateResizeData(((Element)innerNode).getAttribute(ATTRIBUTE_HEIGHT), "top", ((Element)innerNode).getAttribute(ATTRIBUTE_TAG_XPATH), ((Element)innerNode).getAttribute(ATTRIBUTE_TEST), ((Element)innerNode).getAttribute(ATTRIBUTE_DISABLE_ABSOLUTE_POSITION));
                        } else {
                            resizeHeight.setNext(new TemplateResizeData(((Element)innerNode).getAttribute(ATTRIBUTE_HEIGHT), "top", ((Element)innerNode).getAttribute(ATTRIBUTE_TAG_XPATH), ((Element)innerNode).getAttribute(ATTRIBUTE_TEST), ((Element)innerNode).getAttribute(ATTRIBUTE_DISABLE_ABSOLUTE_POSITION)));
                            resizeHeight = resizeHeight.getNext();
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void resize(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Object data, int resizeConstrant, int top, int left, int width, int height) {
        pageContext.getEditPart().getSourceEditor().getTextViewer().getUndoManager().beginCompoundChange();
        if (VpePageContext.isAbsolutePosition() && (resizeConstrant == 32 || resizeConstrant == 8 || resizeConstrant == 1 || resizeConstrant == 2 || resizeConstrant == 4)) {
            if (this.horizontalData != null) {
                this.runResize(pageContext, sourceElement, true, left, width, this.horizontalData);
            }
            if (this.verticalData != null) {
                this.runResize(pageContext, sourceElement, true, top, height, this.verticalData);
            }
        } else {
            if (this.horizontalData != null && resizeConstrant != 2 && resizeConstrant != 64) {
                this.runResize(pageContext, sourceElement, false, left, width, this.horizontalData);
            }
            if (this.verticalData != null && resizeConstrant != 8 && resizeConstrant != 16) {
                this.runResize(pageContext, sourceElement, false, top, height, this.verticalData);
            }
        }
        pageContext.getEditPart().getSourceEditor().getTextViewer().getUndoManager().endCompoundChange();
    }

    private void runResize(VpePageContext pageContext, Element sourceElement, boolean absolute, int position, int size, TemplateResizeData data) {
        TemplateResizeData resizeData = data;
        while (resizeData != null) {
            if (resizeData.getExpression() != null) {
                try {
                    VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(resizeData.getExpression(), false);
                    VpeExpression testExpr = info.getExpression();
                    VpeValue value = testExpr.exec(pageContext, sourceElement);
                    if (value.booleanValue()) {
                        this.setSize(resizeData, sourceElement, absolute, position, size);
                        break;
                    }
                    resizeData = resizeData.getNext();
                }
                catch (VpeExpressionBuilderException ex) {
                    VpePlugin.reportProblem(ex);
                    resizeData = resizeData.getNext();
                }
                catch (VpeExpressionException ex) {
                    VpePlugin.reportProblem(ex);
                    resizeData = resizeData.getNext();
                }
                continue;
            }
            this.setSize(resizeData, sourceElement, absolute, position, size);
            break;
        }
    }

    public void modifyTagDescription(VpeTagDescription tagDescription) {
        if (this.horizontalData != null && this.verticalData != null) {
            tagDescription.setResizeConstrains(255);
        } else if (this.horizontalData != null) {
            tagDescription.setResizeConstrains(24);
        } else if (this.verticalData != null) {
            tagDescription.setResizeConstrains(66);
        } else {
            tagDescription.setResizeConstrains(0);
        }
    }

    private void setSize(TemplateResizeData resizeData, Element sourceElement, boolean absolute, int position, int size) {
        String sizeAttribute = resizeData.getSizeAttribute();
        String positionAttribute = resizeData.getPositionAttribute();
        if (absolute && resizeData.isAbsolutePositionEnabled()) {
            VpeStyleUtil.setAbsolute(sourceElement);
            VpeStyleUtil.setParameterInStyle(sourceElement, "style." + positionAttribute, String.valueOf(position) + "px");
        } else if (VpeStyleUtil.getAbsolute(sourceElement)) {
            VpeStyleUtil.setParameterInStyle(sourceElement, "style." + positionAttribute, String.valueOf(position) + "px");
        }
        if (resizeData.getTagXpath() != null) {
            Element ancestor = (Element)SourceDomUtil.getAncestorNode(sourceElement, resizeData.getTagXpath());
            if (ancestor != null) {
                if (sizeAttribute.indexOf(".") < 0) {
                    ancestor.setAttribute(sizeAttribute, "" + size);
                } else {
                    VpeStyleUtil.setParameterInStyle(ancestor, sizeAttribute, String.valueOf(size) + "px");
                }
            }
        } else if (sizeAttribute.indexOf(".") < 0) {
            sourceElement.setAttribute(sizeAttribute, "" + size);
        } else {
            VpeStyleUtil.setParameterInStyle(sourceElement, sizeAttribute, String.valueOf(size) + "px");
        }
    }
}

