/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar.format;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.toolbar.SplitToolBar;
import org.jboss.tools.vpe.editor.toolbar.format.AttributeFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.BackgroundColorFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.BlockFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.BoldFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.FontNameFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.FontSizeFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.ForegroundColorFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.editor.toolbar.format.ItalicFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.StyleFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.UnderlineFormatController;
import org.jboss.tools.vpe.messages.VpeUIMessages;

public class TextFormattingToolBar
extends SplitToolBar {
    private static final String NORMAL_BLOCK_FORMAT = "- Block Format -";
    private static final String NORMAL_FONT = "- Font Name -";
    private static final String NORMAL_SIZE = "- Font Size -";
    private static final String ID = "TEXT_FORMATTING_TOOLBAR";
    private static String[] FONT_ARRAY = new String[]{"Arial", "Courier New", "Times New Roman", "Comic Sans", "MS Serif", "Tahoma", "Verdana"};
    private ToolBar toolBar;
    private ToolBar floatingBar;
    private FormatControllerManager formatControllerManager;
    private List<Image> imagesList = new ArrayList<Image>();

    public TextFormattingToolBar(FormatControllerManager formatControllerManager) {
        this.formatControllerManager = formatControllerManager;
    }

    @Override
    public String getName() {
        return VpeUIMessages.TEXT_FORMATTING;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public Composite getComposite() {
        return this.toolBar;
    }

    @Override
    public void createItems(ToolBar parent) {
        this.toolBar = parent;
        this.toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (Image image : TextFormattingToolBar.this.imagesList) {
                    image.dispose();
                }
                TextFormattingToolBar.this.imagesList.clear();
            }
        });
        ToolItem emptySeparator = new ToolItem(this.toolBar, 2);
        Label emptyLabel = new Label((Composite)this.toolBar, 0);
        emptySeparator.setControl((Control)emptyLabel);
        emptySeparator.setWidth(1);
        ArrayList<String> blockFormatItems = new ArrayList<String>();
        blockFormatItems.add(NORMAL_BLOCK_FORMAT);
        blockFormatItems.add("Address");
        int i = 1;
        while (i < 7) {
            blockFormatItems.add("Heading " + i);
            ++i;
        }
        Combo comboBlockFormat = this.createComboToolItem(this.toolBar, 8, VpeUIMessages.BLOCK_FORMAT, blockFormatItems, 0);
        comboBlockFormat.addListener(13, (Listener)new BlockFormatController(this.formatControllerManager, comboBlockFormat));
        ArrayList<String> fonts = new ArrayList<String>();
        fonts.add(NORMAL_FONT);
        try {
            fonts.addAll(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()));
        }
        catch (Error ex) {
            VpePlugin.getPluginLog().logWarning((Throwable)ex);
            fonts.addAll(Arrays.asList(FONT_ARRAY));
        }
        Combo comboFont = this.createComboToolItem(this.toolBar, 8, VpeUIMessages.FONT_NAME, fonts, 0);
        comboFont.addListener(13, (Listener)new FontNameFormatController(this.formatControllerManager, comboFont, NORMAL_FONT));
        ArrayList<String> fontSizes = new ArrayList<String>();
        fontSizes.add(NORMAL_SIZE);
        int i2 = 1;
        while (i2 < 8) {
            fontSizes.add(Integer.toString(i2));
            ++i2;
        }
        Combo comboFontSize = this.createComboToolItem(this.toolBar, 29, VpeUIMessages.FONT_SIZE, fontSizes, 2);
        comboFontSize.addListener(13, (Listener)new FontSizeFormatController(this.formatControllerManager, comboFontSize));
        ToolItem item = this.createToolItem(this.toolBar, 32, this.createImage("icons/bold.gif"), VpeUIMessages.BOLD);
        AttributeFormatController listener = new BoldFormatController(this.formatControllerManager, item);
        item.addListener(13, (Listener)listener);
        item = this.createToolItem(this.toolBar, 32, this.createImage("icons/italic.gif"), VpeUIMessages.ITALIC);
        listener = new ItalicFormatController(this.formatControllerManager, item);
        item.addListener(13, (Listener)listener);
        item = this.createToolItem(this.toolBar, 32, this.createImage("icons/uderline.gif"), VpeUIMessages.UNDERLINE);
        listener = new UnderlineFormatController(this.formatControllerManager, item);
        item.addListener(13, (Listener)listener);
        item = this.createToolItem(this.toolBar, 8, this.createImage("icons/background.gif"), VpeUIMessages.BACKGROUND_COLOR);
        listener = new BackgroundColorFormatController(this.formatControllerManager, item);
        item.addListener(13, (Listener)listener);
        item = this.createToolItem(this.toolBar, 8, this.createImage("icons/foreground.gif"), VpeUIMessages.FOREGROUND_COLOR);
        listener = new ForegroundColorFormatController(this.formatControllerManager, item);
        item.addListener(13, (Listener)listener);
        item = this.createToolItem(this.toolBar, 8, this.createImage(WebUiPlugin.getImageDescriptor((String)"images/cssdialog/color_large.gif")), VpeUIMessages.EDIT_STYLE_ATTRIBUTE);
        listener = new StyleFormatController(this.formatControllerManager, item);
        item.addListener(13, (Listener)listener);
    }

    private Image createImage(String path) {
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromFile(MozillaEditor.class, (String)path);
        return this.createImage(imageDescriptor);
    }

    private Image createImage(ImageDescriptor imageDescriptor) {
        Image image = imageDescriptor.createImage();
        this.imagesList.add(image);
        return image;
    }
}

