/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.xpath.core.util.XSLTXPathHelper;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.proxy.VpeProxyUtil;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SourceDomUtil {
    private static final Set<String> TEMPLATES_NAMESPACES_WITH_RENDERED = new HashSet<String>();

    static {
        TEMPLATES_NAMESPACES_WITH_RENDERED.add("h:");
        TEMPLATES_NAMESPACES_WITH_RENDERED.add("a4j:");
        TEMPLATES_NAMESPACES_WITH_RENDERED.add("rich:");
        TEMPLATES_NAMESPACES_WITH_RENDERED.add("seam:");
    }

    public static Node getAncestorNode(Node sourceNode, String tagName) {
        if (tagName == null) {
            return null;
        }
        Node element = sourceNode;
        do {
            if (!tagName.equalsIgnoreCase(element.getNodeName())) continue;
            return element;
        } while ((element = element.getParentNode()) != null);
        return null;
    }

    public static Node getParentHavingDomMapping(Node sourceNode, VpeDomMapping domMapping) {
        VpeNodeMapping nodeMapping = null;
        Node parent = sourceNode;
        while ((nodeMapping = domMapping.getNodeMapping(parent = parent.getParentNode())) == null && parent != null) {
        }
        return parent;
    }

    public static boolean isRenderedAttrEqFalse(VpePageContext pageContext, Element sourceNode) {
        boolean result = false;
        String ATTR_RENDERED = "rendered";
        Element tempElement = sourceNode;
        if (sourceNode.hasAttribute("rendered")) {
            String templateName;
            String[] templatePrefix;
            if (pageContext.getElService().isELNode(sourceNode)) {
                tempElement = (Element)VpeProxyUtil.createProxyForELExpressionNode(pageContext, sourceNode);
            }
            if ("false".equals(tempElement.getAttribute("rendered")) && (templatePrefix = (templateName = VpeTemplateManager.getInstance().getTemplateName(pageContext, sourceNode)).split(":")).length > 1 && TEMPLATES_NAMESPACES_WITH_RENDERED.contains(String.valueOf(templatePrefix[0]) + ":")) {
                result = true;
            }
        }
        return result;
    }

    public static Element getFacetByName(VpePageContext pageContext, Element sourceElement, String facetName) {
        if (facetName == null) {
            return null;
        }
        Element facetElement = null;
        NodeList children = sourceElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (SourceDomUtil.isFacetElement(pageContext, node) && facetName.equalsIgnoreCase(((Element)node).getAttribute("name"))) {
                facetElement = (Element)node;
            }
            ++i;
        }
        return facetElement;
    }

    public static boolean isFacetElement(VpePageContext pageContext, Node node) {
        if (node instanceof Element) {
            String templateName = VpeTemplateManager.getInstance().getTemplateName(pageContext, node);
            return "f:facet".equals(templateName);
        }
        return false;
    }

    public static String getXPath(Node node) {
        return XSLTXPathHelper.calculateXPathToNode((Node)node);
    }

    public static Node getNodeByXPath(Document document, String xPath) {
        Node currentNode = document;
        String[] nodeNames = xPath.split("/");
        int i = 1;
        while (i < nodeNames.length) {
            String nodeName = nodeNames[i];
            if (nodeName.charAt(0) != '@') {
                currentNode = currentNode.getFirstChild();
                if (nodeName.charAt(nodeName.length() - 1) != ']') {
                    while (currentNode.getNodeType() != 1 || !currentNode.getNodeName().equals(nodeName)) {
                        currentNode = currentNode.getNextSibling();
                    }
                } else {
                    int openingBracketIndex = nodeName.lastIndexOf(91);
                    String stringPosition = nodeName.substring(openingBracketIndex + 1, nodeName.length() - 1);
                    nodeName = nodeName.substring(0, openingBracketIndex);
                    int position = Integer.parseInt(stringPosition);
                    int curPosition = 0;
                    while (currentNode.getNodeType() != 1 || !currentNode.getNodeName().equals(nodeName) || ++curPosition != position) {
                        currentNode = currentNode.getNextSibling();
                    }
                }
            } else {
                String attributeName = nodeName.substring(1, nodeName.length());
                currentNode = currentNode.getAttributes().getNamedItem(attributeName);
            }
            ++i;
        }
        return currentNode;
    }

    public static final int getLinePositionOffset(ITextViewer itextViewer, int lineIndex, int linePosition) {
        int resultOffset = -1;
        StyledText textWidget = itextViewer.getTextWidget();
        if (textWidget != null && lineIndex <= textWidget.getLineCount()) {
            resultOffset = textWidget.getOffsetAtLine(lineIndex);
            int tabWidth = textWidget.getTabs();
            int characterOffset = 0;
            String currentString = textWidget.getLine(lineIndex);
            int pos = 1;
            int i = 0;
            while (i < currentString.length() && pos < linePosition) {
                if ('\t' == currentString.charAt(i)) {
                    characterOffset += tabWidth == 0 ? 0 : 1;
                    pos += tabWidth;
                } else {
                    ++pos;
                    ++characterOffset;
                }
                ++i;
            }
            if (textWidget.getLineAtOffset(resultOffset += characterOffset) != lineIndex) {
                resultOffset = -1;
            }
        }
        return resultOffset;
    }

    public static Node getSourceNodeByEditorPosition(ITextViewer itextViewer, int lineIndex, int linePosition) {
        int offset = SourceDomUtil.getLinePositionOffset(itextViewer, lineIndex, linePosition);
        if (offset != -1) {
            return (Node)ContentAssistUtils.getNodeAt((ITextViewer)itextViewer, (int)offset);
        }
        return null;
    }
}

