/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.model.ui.ModelUIImages;
import org.jboss.tools.vpe.editor.template.VpeAnyData;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.wizards.VpeImportExportWizardPage;
import org.jboss.tools.vpe.editor.wizards.VpeImportExportWizardsUtils;
import org.jboss.tools.vpe.messages.VpeUIMessages;

public class ImportUserTagsTemplatesWizardPage
extends WizardPage
implements VpeImportExportWizardPage {
    private String pathString;
    private Table tagsTable;
    private List<VpeAnyData> tagsList;
    private List<VpeAnyData> currentList;
    private List<VpeAnyData> importedList = new ArrayList<VpeAnyData>();

    protected ImportUserTagsTemplatesWizardPage(String pageName, List<VpeAnyData> currentList) {
        super(pageName);
        this.currentList = currentList;
        this.setTitle(VpeUIMessages.IMPORT_USER_TAGS_PAGE_TITLE);
        this.setDescription(VpeUIMessages.IMPORT_USER_TAGS_PAGE_DESCRIPTION);
        this.setImageDescriptor(ModelUIImages.getImageDescriptor((String)ModelUIImages.WIZARD_IMPORT_TAG_TEMPLATE));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setFont(parent.getFont());
        Label fileNamaLabel = new Label(composite, 0);
        fileNamaLabel.setLayoutData((Object)new GridData(16384, 1024, false, false, 1, 1));
        fileNamaLabel.setText(VpeUIMessages.FILE_NAME_LABEL);
        final Text pathText = new Text(composite, 2048);
        pathText.setEditable(true);
        pathText.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportUserTagsTemplatesWizardPage.this.pathString = ((Text)e.getSource()).getText();
                IPath enteredPath = null;
                if (Path.ROOT.isValidPath(ImportUserTagsTemplatesWizardPage.this.pathString) && (enteredPath = Path.fromOSString((String)ImportUserTagsTemplatesWizardPage.this.pathString)).toFile().exists()) {
                    ImportUserTagsTemplatesWizardPage.this.tagsList = VpeTemplateManager.getInstance().getAnyTemplates(enteredPath);
                } else if (ImportUserTagsTemplatesWizardPage.this.tagsList != null) {
                    ImportUserTagsTemplatesWizardPage.this.tagsList.clear();
                }
                VpeImportExportWizardsUtils.updateTagsTable(ImportUserTagsTemplatesWizardPage.this.tagsTable, ImportUserTagsTemplatesWizardPage.this.tagsList, true);
                ImportUserTagsTemplatesWizardPage.this.setPageComplete(ImportUserTagsTemplatesWizardPage.this.isPageComplete());
            }
        });
        Button browseButton = new Button(composite, 0);
        browseButton.setText(VpeUIMessages.BROWSE_BUTTON_TEXT);
        browseButton.setLayoutData((Object)new GridData(4, 1024, false, false, 1, 1));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 0);
                String path = dialog.open();
                if (path != null) {
                    File file = new File(path);
                    ImportUserTagsTemplatesWizardPage.this.pathString = file.toString();
                    pathText.setText(ImportUserTagsTemplatesWizardPage.this.pathString);
                }
            }
        });
        this.tagsTable = new Table(composite, 2048);
        TableLayout layout = new TableLayout();
        this.tagsTable.setLayout((Layout)layout);
        this.tagsTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.tagsTable.setHeaderVisible(true);
        this.tagsTable.setLinesVisible(true);
        int i = 0;
        while (i < COLUMNS_NAMES.length) {
            TableColumn column = new TableColumn(this.tagsTable, 0);
            column.setText(COLUMNS_NAMES[i]);
            ColumnWeightData columnLayoutData = new ColumnWeightData(COLUMNS_WIDTHS[i], true);
            layout.addColumnData((ColumnLayoutData)columnLayoutData);
            ++i;
        }
        this.setErrorMessage(null);
        this.setControl((Control)composite);
    }

    public boolean isPageComplete() {
        boolean isPageComplete = false;
        if (this.pathString != null && !"".equalsIgnoreCase(this.pathString) && Path.ROOT.isValidPath(this.pathString) && Path.fromOSString((String)this.pathString).toFile().exists()) {
            isPageComplete = true;
        }
        return isPageComplete;
    }

    public boolean finish() {
        this.importedList.clear();
        this.importedList.addAll(this.tagsList);
        Iterator<VpeAnyData> iterator = this.importedList.iterator();
        while (iterator.hasNext()) {
            VpeAnyData loadedTemplate = iterator.next();
            for (VpeAnyData currentTemplate : this.currentList) {
                if (!loadedTemplate.equals(currentTemplate)) continue;
                iterator.remove();
            }
        }
        return true;
    }

    public List<VpeAnyData> getImportedList() {
        return this.importedList;
    }
}

