/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.websockets.ui.internal.ca;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocBrowserInformationControlInput;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.text.edits.MalformedTreeException;
import org.jboss.tools.websockets.ui.internal.ca.WebsocketMethodInfo;

public class MethodCompletionProposal
extends JavaTypeCompletionProposal
implements ICompletionProposalExtension4 {
    private final IJavaProject fJavaProject;
    private final WebsocketMethodInfo methodInfo;
    private final int position;
    private final int prefixLength;

    public MethodCompletionProposal(IJavaProject jproject, ICompilationUnit cu, WebsocketMethodInfo methodInfo, int start, int length, int position, int prefixLength, String completionProposal) {
        super(completionProposal, cu, start, length, JavaPluginImages.get((String)"org.eclipse.jdt.ui.methpub_obj.gif"), methodInfo.displayName, 20000);
        Assert.isNotNull((Object)jproject);
        Assert.isNotNull((Object)methodInfo.methodName);
        Assert.isNotNull((Object)methodInfo.paramTypes);
        Assert.isNotNull((Object)cu);
        this.methodInfo = methodInfo;
        this.position = position;
        this.prefixLength = prefixLength;
        this.fJavaProject = jproject;
        this.setReplacementString(completionProposal);
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.methodInfo.methodName;
    }

    private CompilationUnit getRecoveredAST(IDocument document, int offset, Document recoveredDocument) {
        CompilationUnit ast = SharedASTProvider.getAST((ITypeRoot)this.fCompilationUnit, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_ACTIVE_ONLY, null);
        if (ast != null) {
            recoveredDocument.set(document.get());
            return ast;
        }
        char[] content = document.get().toCharArray();
        int index = offset - 1;
        while (index >= 0 && Character.isJavaIdentifierPart(content[index])) {
            content[index] = 32;
            --index;
        }
        recoveredDocument.set(new String(content));
        ASTParser parser = ASTParser.newParser((int)9);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setSource(content);
        parser.setUnitName(this.fCompilationUnit.getElementName());
        parser.setProject(this.fCompilationUnit.getJavaProject());
        return (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset, ImportRewrite importRewrite) throws CoreException, BadLocationException {
        Document recoveredDocument = new Document();
        CompilationUnit unit = this.getRecoveredAST(document, offset, recoveredDocument);
        if (importRewrite == null) {
            importRewrite = StubUtility.createImportRewrite((CompilationUnit)unit, (boolean)true);
        }
        ITypeBinding declaringType = null;
        ChildListPropertyDescriptor descriptor = null;
        ASTNode node = NodeFinder.perform((ASTNode)unit, (int)this.position, (int)1);
        if ((node instanceof SimpleName || node instanceof Modifier) && (node = node.getParent()) instanceof MarkerAnnotation) {
            node = node.getParent();
        }
        if (node instanceof MethodDeclaration || node instanceof FieldDeclaration) {
            node = node.getParent();
        }
        if (node instanceof AnonymousClassDeclaration) {
            declaringType = ((AnonymousClassDeclaration)node).resolveBinding();
            descriptor = AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        } else if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)node;
            descriptor = declaration.getBodyDeclarationsProperty();
            declaringType = declaration.resolveBinding();
        }
        if (declaringType != null) {
            ASTRewrite rewrite = ASTRewrite.create((AST)unit.getAST());
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)this.fJavaProject);
            String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)unit.getTypeRoot());
            StringBuffer content = new StringBuffer();
            if (this.methodInfo.annotation != null) {
                importRewrite.addImport(this.methodInfo.annotation);
                int dot = this.methodInfo.annotation.lastIndexOf(46);
                String simpleName = this.methodInfo.annotation.substring(dot + 1);
                content.append("@").append(simpleName).append(delimiter);
            }
            content.append("public void " + this.methodInfo.methodName + "(");
            boolean first = true;
            int i = 0;
            while (i < this.methodInfo.paramTypes.length) {
                String paramType = this.methodInfo.paramTypes[i];
                if (!first) {
                    content.append(", ");
                } else {
                    first = false;
                }
                importRewrite.addImport(paramType);
                String simpleName = paramType.substring(paramType.lastIndexOf(46) + 1);
                String name = this.methodInfo.paramNames != null ? this.methodInfo.paramNames[i] : String.valueOf(simpleName.substring(0, 1).toLowerCase()) + simpleName.substring(1);
                content.append(simpleName).append(" ").append(name);
                ++i;
            }
            content.append(") {").append(delimiter).append("\t\t");
            String body = StubUtility.getMethodBodyContent((boolean)false, (IJavaProject)this.fJavaProject, (String)declaringType.getName(), (String)declaringType.getName(), (String)"", (String)delimiter);
            if (body == null || body.length() == 0) {
                body = delimiter;
            }
            content.append(body);
            content.append("}").append(delimiter);
            MethodDeclaration stub = (MethodDeclaration)rewrite.createStringPlaceholder(CodeFormatterUtil.format((int)4, (String)content.toString(), (int)0, (String)delimiter, (IJavaProject)unit.getTypeRoot().getJavaProject()), 31);
            ListRewrite rewriter = rewrite.getListRewrite(node, descriptor);
            rewriter.insertFirst((ASTNode)stub, null);
            ITrackedNodePosition position = rewrite.track((ASTNode)stub);
            try {
                rewrite.rewriteAST((IDocument)recoveredDocument, this.fJavaProject.getOptions(true)).apply((IDocument)recoveredDocument);
                String generatedCode = recoveredDocument.get(position.getStartPosition(), position.getLength());
                int generatedIndent = IndentManipulation.measureIndentUnits((CharSequence)MethodCompletionProposal.getIndentAt((IDocument)recoveredDocument, position.getStartPosition(), settings), (int)settings.tabWidth, (int)settings.indentWidth);
                String indent = MethodCompletionProposal.getIndentAt(document, this.getReplacementOffset(), settings);
                if (this.position > offset && indent.length() == 0) {
                    indent = "\t";
                }
                String replacementString = IndentManipulation.changeIndent((String)generatedCode, (int)generatedIndent, (int)settings.tabWidth, (int)settings.indentWidth, (String)indent, (String)TextUtilities.getDefaultLineDelimiter((IDocument)document));
                if (this.position > offset) {
                    replacementString = "\t" + replacementString + delimiter;
                    this.setReplacementLength(this.getReplacementLength());
                    this.setReplacementOffset(this.getReplacementOffset() + this.position - offset);
                } else if (this.prefixLength > 0) {
                    this.setReplacementLength(this.getReplacementLength() + this.prefixLength);
                    this.setReplacementOffset(this.getReplacementOffset() - this.prefixLength);
                }
                this.setReplacementString(replacementString);
            }
            catch (MalformedTreeException exception) {
                JavaPlugin.log((Throwable)exception);
            }
            catch (BadLocationException exception) {
                JavaPlugin.log((Throwable)exception);
            }
        }
        return true;
    }

    private static String getIndentAt(IDocument document, int offset, CodeGenerationSettings settings) {
        try {
            IRegion region = document.getLineInformationOfOffset(offset);
            return IndentManipulation.extractIndentString((String)document.get(region.getOffset(), region.getLength()), (int)settings.tabWidth, (int)settings.indentWidth);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        String info = this.methodInfo.info;
        if (info != null && info.length() > 0) {
            StringBuffer buffer = new StringBuffer();
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)this.getCSSStyles());
            buffer.append(info);
            IJavaProject element = null;
            try {
                String base;
                element = this.fJavaProject;
                if (element instanceof IMember && (base = JavaDocLocations.getBaseURL((IJavaElement)element, (boolean)false)) != null) {
                    int endHeadIdx = buffer.indexOf("</head>");
                    buffer.insert(endHeadIdx, "\n<base href='" + base + "'>\n");
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log((Throwable)e);
            }
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            info = buffer.toString();
            return new JavadocBrowserInformationControlInput(null, (IJavaElement)element, info, 0);
        }
        return null;
    }
}

