/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.JavaElementChangedEvent;
import org.jboss.tools.ws.jaxrs.core.internal.utils.ConstantUtils;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;

public class JavaElementDeltaFilter {
    private static final int WORKING_COPY = 1;
    private static final int PRIMARY_COPY = 2;
    private final List<Rule> rules = new ArrayList<Rule>();

    public JavaElementDeltaFilter() {
        this.accept().when(2).is(1).after(4).in(2);
        this.accept().when(2).is(2).after(4).in(2);
        this.accept().when(2).is(4).withFlags(512).after(1).in(2);
        this.accept().when(2).is(4).withFlags(0x220009).after(1).in(2);
        this.accept().when(3).is(1).after(1).in(2);
        this.accept().when(3).is(1).withFlags(64).after(1).in(2);
        this.accept().when(3).is(2).withFlags(128).after(1).in(2);
        this.accept().when(5).is(1).after(4).in(2);
        this.accept().when(5).is(4).withFlags(262145).after(4).in(2);
        this.accept().when(5).is(4).withFlags(540673).after(4).in(1);
        this.accept().when(5).is(2).after(4).in(3);
        this.accept().when(7).is(1).after(5).in(3);
        this.accept().when(7).is(4).withFlags(2048).after(5).in(1);
        this.accept().when(7).is(4).withFlags(0x800000).after(5).in(1);
        this.accept().when(7).is(2).after(5).in(3);
        this.accept().when(9).is(1).after(5).in(3);
        this.accept().when(9).is(4).withFlags(0x2000000).after(5).in(3);
        this.accept().when(9).is(4).withFlags(0x800000).after(5).in(3);
        this.accept().when(9).is(4).withFlags(0x1000000).after(5).in(3);
        this.accept().when(9).is(2).after(5).in(3);
        this.accept().when(9).is(2).withFlags(1).after(5).in(3);
        this.accept().when(8).is(1).after(5).in(3);
        this.accept().when(8).is(4).withFlags(1).after(5).in(3);
        this.accept().when(8).is(2).after(5).in(3);
        this.accept().when(16).is(1).after(5).in(3);
        this.accept().when(16).is(4).withFlags(1).after(5).in(3);
        this.accept().when(16).is(2).after(5).in(3);
    }

    private RuleBuilder accept() {
        return new RuleBuilder();
    }

    public boolean apply(JavaElementChangedEvent event) {
        if (event.getElement() == null) {
            return false;
        }
        int elementKind = event.getElement().getElementType();
        int deltaKind = event.getKind();
        IJavaElement element = event.getElement();
        if (this.isPackageInfoFile(element) || this.isJarArchive(element)) {
            return false;
        }
        Flags flags = event.getFlags();
        if (flags.hasExactValue(0x400000)) {
            return false;
        }
        boolean workingCopy = JdtUtils.isWorkingCopy(element);
        boolean match = this.apply(elementKind, deltaKind, event.getEventType(), flags, workingCopy);
        if (match) {
            Logger.trace("**accepted** {}", event);
        } else {
            Logger.trace("**rejected** {}", event);
        }
        return match;
    }

    private boolean isJarArchive(IJavaElement element) {
        return element.getElementType() == 3 && ((IPackageFragmentRoot)element).isArchive();
    }

    private boolean isPackageInfoFile(IJavaElement element) {
        return element.getResource() != null && element.getResource().getType() == 1 && element.getResource().getName().equals("package-info.java");
    }

    protected boolean apply(int elementKind, int deltaKind, int eventType, Flags flags, boolean workingCopy) {
        Rule matcher = new Rule(elementKind, deltaKind, eventType, workingCopy ? 1 : 2, flags);
        for (Rule rule : this.rules) {
            if (!rule.match(matcher)) continue;
            Logger.trace("Rule {} matched", rule);
            return true;
        }
        return false;
    }

    static class Rule {
        private final int elementKind;
        private final int deltaKind;
        private final int eventType;
        private final int unitContext;
        private final Flags flags;

        Rule(int elementKind, int deltaKind, int eventType, int unitContext, Flags flags) {
            this.elementKind = elementKind;
            this.deltaKind = deltaKind;
            this.eventType = eventType;
            this.unitContext = unitContext;
            this.flags = flags;
        }

        public boolean match(Rule matcher) {
            return this.elementKind == matcher.elementKind && this.deltaKind == matcher.deltaKind && (this.eventType & matcher.eventType) > 0 && (this.unitContext & matcher.unitContext) != 0 && this.flags.equals(matcher.flags);
        }

        public String toString() {
            return "[" + ConstantUtils.getStaticFieldName(ElementChangedEvent.class, this.eventType) + "] " + ConstantUtils.getStaticFieldName(IJavaElement.class, this.elementKind) + " " + "[" + ConstantUtils.getStaticFieldName(IJavaElementDelta.class, this.deltaKind) + "]: ";
        }
    }

    class RuleBuilder {
        private int elementKind;
        private int deltaKind;
        private int eventType;
        private int unitContext;
        private Flags flags = Flags.NONE;

        private RuleBuilder() {
        }

        public RuleBuilder when(int elementKind) {
            this.elementKind = elementKind;
            return this;
        }

        public RuleBuilder withFlags(int flags) {
            this.flags = new Flags(flags);
            return this;
        }

        public RuleBuilder is(int deltaKind) {
            this.deltaKind = deltaKind;
            return this;
        }

        public RuleBuilder after(int eventType) {
            this.eventType = eventType;
            return this;
        }

        public void in(int unitContext) {
            this.unitContext = unitContext;
            Rule rule = new Rule(this.elementKind, this.deltaKind, this.eventType, this.unitContext, this.flags);
            JavaElementDeltaFilter.this.rules.add(rule);
        }
    }
}

