/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.ResourceDelta;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.ResourceDeltaScanner;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.utils.JobMonitor;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsMetamodelLocator;

public class ResourceChangedBuildJob
extends Job {
    private final IResourceChangeEvent event;
    private final IJavaProject javaProject;

    public ResourceChangedBuildJob(IJavaProject javaProject, IResourceChangeEvent event) {
        super("JAX-RS Metamodel build...");
        this.event = event;
        this.javaProject = javaProject;
        this.setPriority(40);
        Logger.debug("Kicking a new ResourceChangedBuildJob (#{}) to process {}", JobMonitor.getJobId(this), event.getDelta());
        this.addJobChangeListener((IJobChangeListener)new JobMonitor());
    }

    protected IStatus run(IProgressMonitor progressMonitor) {
        long endTime;
        IStatus iStatus;
        List<ResourceDelta> affectedResources;
        JaxrsMetamodel metamodel;
        long startTime;
        block15: {
            startTime = new Date().getTime();
            metamodel = null;
            progressMonitor.beginTask("Building JAX-RS Metamodel", 30);
            Logger.debug("Building JAX-RS Metamodel after resource changed...");
            affectedResources = this.extractAffectedResources(this.event.getDelta(), progressMonitor);
            progressMonitor.worked(10);
            if (!progressMonitor.isCanceled()) break block15;
            IStatus iStatus2 = Status.CANCEL_STATUS;
            long endTime2 = new Date().getTime();
            if (Logger.isDebugEnabled()) {
                Logger.debug("JAX-RS Metamodel for project '{}' built in {} ms, ended with status {}.", this.javaProject.getElementName(), endTime2 - startTime, metamodel != null ? metamodel.getStatus() : "unknown");
            }
            progressMonitor.done();
            return iStatus2;
        }
        try {
            metamodel = JaxrsMetamodelLocator.get(this.javaProject);
            if (metamodel == null) {
                metamodel = JaxrsMetamodelLocator.get(this.javaProject, true);
                if (metamodel != null) {
                    metamodel.processProject(progressMonitor);
                }
            } else if (this.event.getBuildKind() == 6 || this.event.getBuildKind() == 15 || metamodel.isInitializing()) {
                metamodel.processProject(progressMonitor);
            } else {
                metamodel.processAffectedResources(affectedResources, progressMonitor);
            }
            iStatus = Status.OK_STATUS;
            endTime = new Date().getTime();
        }
        catch (Exception e) {
            long endTime3;
            Status status;
            try {
                Status status2 = Logger.error("Failed to (re)build the JAX-RS metamodel for projet " + this.javaProject.getElementName(), e);
                if (metamodel != null) {
                    metamodel.setBuildStatus((IStatus)status2);
                }
                status = status2;
                endTime3 = new Date().getTime();
            }
            catch (Throwable throwable) {
                long endTime4 = new Date().getTime();
                if (Logger.isDebugEnabled()) {
                    Logger.debug("JAX-RS Metamodel for project '{}' built in {} ms, ended with status {}.", this.javaProject.getElementName(), endTime4 - startTime, metamodel != null ? metamodel.getStatus() : "unknown");
                }
                progressMonitor.done();
                throw throwable;
            }
            if (Logger.isDebugEnabled()) {
                Logger.debug("JAX-RS Metamodel for project '{}' built in {} ms, ended with status {}.", this.javaProject.getElementName(), endTime3 - startTime, metamodel != null ? metamodel.getStatus() : "unknown");
            }
            progressMonitor.done();
            return status;
        }
        if (Logger.isDebugEnabled()) {
            Logger.debug("JAX-RS Metamodel for project '{}' built in {} ms, ended with status {}.", this.javaProject.getElementName(), endTime - startTime, metamodel != null ? metamodel.getStatus() : "unknown");
        }
        progressMonitor.done();
        return iStatus;
    }

    private List<ResourceDelta> extractAffectedResources(IResourceDelta delta, IProgressMonitor progressMonitor) throws CoreException {
        ArrayList<ResourceDelta> events = new ArrayList<ResourceDelta>();
        if (delta != null) {
            events.addAll(new ResourceDeltaScanner().scanAndFilterEvent(delta, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor, (int)10)));
        } else {
            events.add(new ResourceDelta((IResource)this.javaProject.getProject(), 4, Flags.NONE));
        }
        return events;
    }
}

