/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsMetamodelLocator;

public class ResourceChangedListener
implements IResourceChangeListener {
    private boolean active = true;

    public void pause() {
        this.active = false;
    }

    public void resume() {
        this.active = true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.active) {
            return;
        }
        if (event.getType() == 2 && event.getResource() != null && event.getResource().getType() == 4) {
            IProject project = (IProject)event.getResource();
            try {
                JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get(project);
                if (metamodel != null) {
                    Logger.debug("Removing JAX-RS Metamodel before closing project " + project.getName());
                    metamodel.remove();
                }
            }
            catch (CoreException e) {
                Logger.error("Error while removing JAX-RS Metamodel", e);
            }
        }
    }
}

