/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.jboss.tools.ws.jaxrs.core.internal.utils.ConstantUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;

public class ResourceDelta {
    private final IResource resource;
    private final int deltaKind;
    private final Flags flags;

    public ResourceDelta(IResource resource, int deltaKind, Flags flags) {
        this.resource = resource;
        this.deltaKind = deltaKind;
        this.flags = flags;
    }

    public IResource getResource() {
        return this.resource;
    }

    public int getDeltaKind() {
        return this.deltaKind;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("ResourceChangedEvent [").append(ConstantUtils.getStaticFieldName(IResource.class, this.resource.getType()));
        result.append(" '").append(this.resource.getFullPath()).append("' ");
        result.append(ConstantUtils.getStaticFieldName(IResourceDelta.class, this.deltaKind).toLowerCase());
        if (this.flags.hasValue()) {
            int[] f = ConstantUtils.splitConstants(IResourceDelta.class, this.flags.getValue(), "");
            result.append(":{");
            int i = 0;
            while (i < f.length) {
                result.append(ConstantUtils.getStaticFieldName(IResourceDelta.class, f[i], ""));
                if (i < f.length - 1) {
                    result.append("+");
                }
                ++i;
            }
            result.append("}");
        }
        result.append("]");
        return result.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.deltaKind;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceDelta other = (ResourceDelta)obj;
        if (this.deltaKind != other.deltaKind) {
            return false;
        }
        if (this.resource == null && other.resource != null) {
            return false;
        }
        if (this.resource != null && other.resource == null) {
            return false;
        }
        if (this.resource != null && other.resource != null && this.resource.getType() != other.resource.getType()) {
            return false;
        }
        return this.resource == null || other.resource == null || this.resource.getName().equals(other.resource.getName());
    }
}

