/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParamAnnotations;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceElement;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.AnnotationUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.jdt.FlagsUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementCategory;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceField;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsResourceField
extends JaxrsResourceElement<IField>
implements IJaxrsResourceField {
    public static Builder from(IField field, CompilationUnit ast) {
        return new Builder(field, ast);
    }

    private JaxrsResourceField(Builder builder) {
        this(builder.javaField, (Map<String, Annotation>)builder.annotations, builder.metamodel, builder.javaFieldType, builder.parentResource, (JaxrsResourceField)null);
    }

    private JaxrsResourceField(IField javaField, Map<String, Annotation> annotations, JaxrsMetamodel metamodel, SourceType javaFieldType, JaxrsResource parentResource, JaxrsResourceField primaryCopy) {
        super(javaField, annotations, metamodel, javaFieldType, parentResource, primaryCopy);
        if (this.getParentResource() != null) {
            this.getParentResource().addField(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JaxrsResourceField createWorkingCopy() {
        JaxrsResourceField jaxrsResourceField = this;
        synchronized (jaxrsResourceField) {
            JaxrsResource parentWorkingCopy = this.getParentResource().getWorkingCopy();
            return parentWorkingCopy.getFields().get(((IField)this.javaElement).getHandleIdentifier());
        }
    }

    protected JaxrsResourceField createWorkingCopy(JaxrsResource parentWorkingCopy) {
        return new JaxrsResourceField((IField)this.getJavaElement(), AnnotationUtils.createWorkingCopies(this.getAnnotations()), this.getMetamodel(), this.getType(), parentWorkingCopy, this);
    }

    @Override
    public JaxrsResourceField getWorkingCopy() {
        return (JaxrsResourceField)super.getWorkingCopy();
    }

    @Override
    public void update(IJavaElement javaElement, CompilationUnit ast) throws CoreException {
        if (javaElement == null) {
            this.remove(FlagsUtils.computeElementFlags(this));
        } else {
            switch (javaElement.getElementType()) {
                case 5: {
                    IType primaryType = ((ICompilationUnit)javaElement).findPrimaryType();
                    if (primaryType == null) break;
                    IField field = primaryType.getField(((IField)this.getJavaElement()).getElementName());
                    this.update((IJavaElement)field, ast);
                    break;
                }
                case 8: {
                    this.update(JaxrsResourceField.from((IField)javaElement, ast).build(false));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(JaxrsResourceField transientField) throws CoreException {
        JaxrsResourceField jaxrsResourceField = this;
        synchronized (jaxrsResourceField) {
            Flags annotationsFlags = FlagsUtils.computeElementFlags(this);
            if (transientField == null) {
                this.remove(annotationsFlags);
            } else {
                Flags updateAnnotationsFlags = this.updateAnnotations(transientField.getAnnotations());
                JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, updateAnnotationsFlags);
                if (this.isMarkedForRemoval()) {
                    this.remove(annotationsFlags);
                } else if (this.hasMetamodel()) {
                    this.getMetamodel().update(delta);
                }
            }
        }
    }

    @Override
    boolean isMarkedForRemoval() {
        boolean hasPathParamAnnotation = this.hasAnnotation("javax.ws.rs.PathParam");
        boolean hasQueryParamAnnotation = this.hasAnnotation("javax.ws.rs.QueryParam");
        boolean hasMatrixParamAnnotation = this.hasAnnotation("javax.ws.rs.MatrixParam");
        return !hasPathParamAnnotation && !hasQueryParamAnnotation && !hasMatrixParamAnnotation;
    }

    @Override
    public void remove(Flags flags) throws CoreException {
        this.getParentResource().removeField(this);
        super.remove(flags);
    }

    public Annotation getPathParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.PathParam");
    }

    public Annotation getQueryParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.QueryParam");
    }

    public Annotation getMatrixParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.MatrixParam");
    }

    public Annotation getDefaultValueAnnotation() {
        return this.getAnnotation("javax.ws.rs.DefaultValue");
    }

    public Annotation getBeanParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.BeanParam");
    }

    @Override
    public EnumElementKind getElementKind() {
        if (this.getPathParamAnnotation() != null) {
            return EnumElementKind.PATH_PARAM_FIELD;
        }
        if (this.getQueryParamAnnotation() != null) {
            return EnumElementKind.QUERY_PARAM_FIELD;
        }
        if (this.getMatrixParamAnnotation() != null) {
            return EnumElementKind.MATRIX_PARAM_FIELD;
        }
        if (this.getBeanParamAnnotation() != null) {
            return EnumElementKind.BEAN_PARAM_FIELD;
        }
        return EnumElementKind.UNDEFINED_RESOURCE_FIELD;
    }

    /* synthetic */ JaxrsResourceField(Builder builder, JaxrsResourceField jaxrsResourceField) {
        this(builder);
    }

    public static class Builder {
        private final IField javaField;
        private final CompilationUnit ast;
        private Map<String, Annotation> annotations;
        private JaxrsResource parentResource;
        private JaxrsMetamodel metamodel;
        private SourceType javaFieldType;

        private Builder(IField javaField, CompilationUnit ast) {
            this.javaField = javaField;
            this.ast = ast;
        }

        public Builder withParentResource(JaxrsResource parentResource) {
            this.parentResource = parentResource;
            return this;
        }

        public Builder withMetamodel(JaxrsMetamodel metamodel) {
            this.metamodel = metamodel;
            return this;
        }

        public Builder withAnnotations(Map<String, Annotation> annotations) {
            this.annotations = annotations;
            return this;
        }

        public JaxrsResourceField build() throws CoreException {
            return this.build(true);
        }

        JaxrsResourceField build(boolean joinMetamodel) throws CoreException {
            long start;
            block9: {
                block8: {
                    block7: {
                        start = System.currentTimeMillis();
                        try {
                            if (this.javaField != null && this.javaField.exists() && this.javaField.isStructureKnown()) break block7;
                        }
                        catch (Throwable throwable) {
                            long end = System.currentTimeMillis();
                            Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                            throw throwable;
                        }
                        long end = System.currentTimeMillis();
                        Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                        return null;
                    }
                    JdtUtils.makeConsistentIfNecessary((IMember)this.javaField);
                    this.javaFieldType = JdtUtils.resolveFieldType(this.javaField, this.ast);
                    IType parentType = (IType)this.javaField.getParent();
                    if (this.parentResource != null || this.metamodel == null) break block8;
                    JaxrsJavaElement parentElement = (JaxrsJavaElement)this.metamodel.findElement((IJavaElement)parentType);
                    if (parentElement != null && parentElement.getElementKind().getCategory() == EnumElementCategory.RESOURCE) {
                        this.parentResource = (JaxrsResource)parentElement;
                        break block8;
                    }
                    Logger.trace("Skipping {}.{} because parent Resource does not exist", parentType.getFullyQualifiedName(), this.javaField.getElementName());
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                    return null;
                }
                if (this.annotations == null) {
                    this.annotations = JdtUtils.resolveAllAnnotations((IMember)this.javaField, this.ast);
                }
                if (!JaxrsParamAnnotations.matchesAtLeastOne(this.annotations.keySet())) break block9;
                JaxrsResourceField field = new JaxrsResourceField(this, null);
                if (joinMetamodel) {
                    field.joinMetamodel();
                }
                JaxrsResourceField jaxrsResourceField = field;
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                return jaxrsResourceField;
            }
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
            return null;
        }
    }
}

