/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaApplication;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.jdt.FlagsUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsApplication;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;
import org.jboss.tools.ws.jaxrs.core.wtp.WtpUtils;

public class JaxrsWebxmlApplication
extends JaxrsBaseElement
implements IJaxrsApplication {
    private String applicationPath;
    private String javaClassName;
    private final IResource webxmlResource;

    public static Builder from(IResource resource) {
        return new Builder(resource);
    }

    private JaxrsWebxmlApplication(Builder builder) {
        this(builder.metamodel, JaxrsWebxmlApplication.normalizeApplicationPath(builder.applicationPath), builder.javaClassName, builder.webxmlResource, null);
    }

    private JaxrsWebxmlApplication(JaxrsMetamodel metamodel, String applicationPath, String javaClassName, IResource webxmlResource, JaxrsWebxmlApplication primaryCopy) {
        super(metamodel, primaryCopy);
        this.applicationPath = applicationPath;
        this.javaClassName = javaClassName;
        this.webxmlResource = webxmlResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JaxrsWebxmlApplication createWorkingCopy() {
        JaxrsWebxmlApplication jaxrsWebxmlApplication = this;
        synchronized (jaxrsWebxmlApplication) {
            return new JaxrsWebxmlApplication(this.getMetamodel(), this.getApplicationPath(), this.getJavaClassName(), this.getResource(), this);
        }
    }

    @Override
    public JaxrsWebxmlApplication getWorkingCopy() {
        return (JaxrsWebxmlApplication)super.getWorkingCopy();
    }

    @Override
    public boolean isBinary() {
        IJavaProject javaProject = this.getMetamodel().getJavaProject();
        IPackageFragmentRoot fragment = javaProject.getPackageFragmentRoot(this.webxmlResource);
        return fragment != null && fragment.exists() && fragment.isArchive();
    }

    @Override
    public boolean isWebXmlApplication() {
        return true;
    }

    @Override
    public boolean isJavaApplication() {
        return false;
    }

    public boolean isOverride() {
        return this.javaClassName != null && !this.javaClassName.equals("javax.ws.rs.core.Application");
    }

    public JaxrsJavaApplication getOverridenJaxrsJavaApplication() {
        if (this.getMetamodel() != null) {
            return this.getMetamodel().findJavaApplicationByTypeName(this.javaClassName);
        }
        return null;
    }

    @Override
    public String getApplicationPath() {
        return this.applicationPath;
    }

    @Override
    public String getJavaClassName() {
        return this.javaClassName;
    }

    public void update(IResource webxmlResource) throws CoreException {
        this.update(JaxrsWebxmlApplication.from(webxmlResource).build(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(JaxrsWebxmlApplication transientWebXmlAppl) throws CoreException {
        JaxrsWebxmlApplication jaxrsWebxmlApplication = this;
        synchronized (jaxrsWebxmlApplication) {
            if (transientWebXmlAppl == null) {
                this.remove(FlagsUtils.computeElementFlags(this));
            } else {
                String eventJavaClassName;
                Flags flags = new Flags();
                String eventApplicationPath = JaxrsWebxmlApplication.normalizeApplicationPath(transientWebXmlAppl.getApplicationPath());
                if (!eventApplicationPath.equals(this.applicationPath)) {
                    JaxrsJavaApplication currentJavaApplication = this.getMetamodel().findJavaApplicationByTypeName(this.javaClassName);
                    if (currentJavaApplication != null) {
                        currentJavaApplication.setApplicationPathOverride(eventApplicationPath);
                    }
                    this.applicationPath = eventApplicationPath;
                    flags.addFlags(16);
                }
                if (!(eventJavaClassName = transientWebXmlAppl.getJavaClassName()).equals(this.javaClassName)) {
                    JaxrsJavaApplication nextJavaApplication;
                    JaxrsJavaApplication previousJavaApplication = this.getMetamodel().findJavaApplicationByTypeName(this.javaClassName);
                    if (previousJavaApplication != null) {
                        previousJavaApplication.unsetApplicationPathOverride();
                    }
                    if ((nextJavaApplication = this.getMetamodel().findJavaApplicationByTypeName(eventJavaClassName)) != null) {
                        nextJavaApplication.setApplicationPathOverride(this.applicationPath);
                    }
                    this.javaClassName = eventJavaClassName;
                    flags.addFlags(32);
                }
                if (flags.hasValue() && this.hasMetamodel()) {
                    JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, flags);
                    this.getMetamodel().update(delta);
                }
            }
        }
    }

    private static String normalizeApplicationPath(String eventApplicationPath) {
        String path = eventApplicationPath.replace("/*", "/");
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    @Override
    public void remove(Flags flags) throws CoreException {
        JaxrsJavaApplication overridenJaxrsJavaApplication = this.getOverridenJaxrsJavaApplication();
        if (overridenJaxrsJavaApplication != null) {
            overridenJaxrsJavaApplication.unsetApplicationPathOverride();
        }
        super.remove(flags);
    }

    @Override
    boolean isMarkedForRemoval() {
        return false;
    }

    @Override
    public EnumElementKind getElementKind() {
        return EnumElementKind.APPLICATION_WEBXML;
    }

    @Override
    public IResource getResource() {
        return this.webxmlResource;
    }

    @Override
    public String getName() {
        return this.webxmlResource != null ? this.webxmlResource.getName() : "*unknown resource*";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.webxmlResource == null ? 0 : this.webxmlResource.getFullPath().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JaxrsWebxmlApplication other = (JaxrsWebxmlApplication)obj;
        if (this.webxmlResource == null && other.webxmlResource != null) {
            return false;
        }
        if (this.webxmlResource != null && other.webxmlResource == null) {
            return false;
        }
        if (this.webxmlResource != null && other.webxmlResource != null && !this.webxmlResource.getFullPath().equals((Object)other.webxmlResource.getFullPath())) {
            return false;
        }
        if (this.javaClassName == null && other.javaClassName != null) {
            return false;
        }
        if (this.javaClassName != null && other.javaClassName == null) {
            return false;
        }
        return this.javaClassName == null || other.javaClassName == null || this.javaClassName.equals(other.javaClassName);
    }

    public String toString() {
        return "WebxmlApplication '" + this.javaClassName + "' -> " + this.applicationPath;
    }

    @Override
    public String getIdentifier() {
        return this.getResource().getFullPath().toPortableString();
    }

    /* synthetic */ JaxrsWebxmlApplication(Builder builder, JaxrsWebxmlApplication jaxrsWebxmlApplication) {
        this(builder);
    }

    public static class Builder {
        private final IResource webxmlResource;
        private final IJavaProject javaProject;
        private JaxrsMetamodel metamodel;
        private String javaClassName;
        private String applicationPath;

        public Builder(IResource webxmlResource) {
            this.webxmlResource = webxmlResource;
            this.javaProject = JavaCore.create((IProject)webxmlResource.getProject());
        }

        public Builder inMetamodel(JaxrsMetamodel metamodel) {
            this.metamodel = metamodel;
            return this;
        }

        public JaxrsWebxmlApplication build() throws CoreException {
            return this.build(true);
        }

        /*
         * Handled impossible loop by adding 'first' condition
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public JaxrsWebxmlApplication build(boolean joinMetamodel) throws CoreException {
            JaxrsWebxmlApplication jaxrsWebxmlApplication;
            Iterator<IType> iterator;
            IType applicationType;
            long start;
            block8: {
                start = System.currentTimeMillis();
                applicationType = JdtUtils.resolveType("javax.ws.rs.core.Application", this.javaProject, (IProgressMonitor)new NullProgressMonitor());
                if (applicationType != null) break block8;
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS WebXmlApplication in {}ms", end - start);
                return null;
            }
            try {
                List<IType> applicationClasses = JdtUtils.findSubtypes(applicationType);
                iterator = applicationClasses.iterator();
                boolean bl = true;
                while (true) {
                    if (bl && !(bl = false)) {
                        if (true) break block9;
                    }
                    IType applicationClass = iterator.next();
                    this.javaClassName = applicationClass.getFullyQualifiedName();
                    this.applicationPath = WtpUtils.getApplicationPath(this.webxmlResource, this.javaClassName);
                    if (this.applicationPath == null) break block9;
                    JaxrsWebxmlApplication webxmlApplication = new JaxrsWebxmlApplication(this, null);
                    if (joinMetamodel) {
                        webxmlApplication.joinMetamodel();
                        JaxrsJavaApplication overridenJaxrsJavaApplication = webxmlApplication.getOverridenJaxrsJavaApplication();
                        if (overridenJaxrsJavaApplication != null) {
                            overridenJaxrsJavaApplication.setApplicationPathOverride(webxmlApplication.getApplicationPath());
                        }
                    }
                    jaxrsWebxmlApplication = webxmlApplication;
                    break;
                }
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS WebXmlApplication in {}ms", end - start);
                throw throwable;
            }
            {
                block9: {
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS WebXmlApplication in {}ms", end - start);
                    return jaxrsWebxmlApplication;
                }
                if (iterator.hasNext()) continue;
            }
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS WebXmlApplication in {}ms", end - start);
            return null;
        }
    }
}

