/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.wtp;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class WtpUtils {
    public static IFolder getWebInfFolder(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return null;
        }
        IVirtualFolder contentFolder = component.getRootFolder();
        return (IFolder)contentFolder.getFolder("WEB-INF").getUnderlyingFolder();
    }

    public static String getApplicationPath(IResource webxmlResource, String applicationTypeName) throws CoreException {
        long startTime;
        block7: {
            block6: {
                startTime = System.currentTimeMillis();
                if (webxmlResource != null) break block6;
                Logger.tracePerf("Found application path for {} in web.xml in {}ms", applicationTypeName, System.currentTimeMillis() - startTime);
                return null;
            }
            String expression = "//servlet-mapping[servlet-name=\"" + applicationTypeName + "\"]/url-pattern/text()";
            Node urlPattern = WtpUtils.evaluateXPathExpression(webxmlResource, expression);
            if (urlPattern == null) break block7;
            Logger.debug("Found matching url-pattern: {} for class {}", urlPattern.getTextContent(), applicationTypeName);
            String string = urlPattern.getTextContent();
            Logger.tracePerf("Found application path for {} in web.xml in {}ms", applicationTypeName, System.currentTimeMillis() - startTime);
            return string;
        }
        try {
            Logger.debug("No servlet mapping found for class '{}' in file '{}'", applicationTypeName, webxmlResource.getProjectRelativePath());
        }
        catch (Exception e) {
            try {
                Logger.error("Unable to parse file '" + webxmlResource.getProjectRelativePath().toOSString() + "' to find <servlet-mapping> elements", e);
            }
            catch (Throwable throwable) {
                Logger.tracePerf("Found application path for {} in web.xml in {}ms", applicationTypeName, System.currentTimeMillis() - startTime);
                throw throwable;
            }
            Logger.tracePerf("Found application path for {} in web.xml in {}ms", applicationTypeName, System.currentTimeMillis() - startTime);
            return null;
        }
        Logger.tracePerf("Found application path for {} in web.xml in {}ms", applicationTypeName, System.currentTimeMillis() - startTime);
        return null;
    }

    public static ISourceRange getApplicationPathLocation(IResource webxmlResource, String applicationTypeName) throws CoreException {
        if (webxmlResource == null) {
            return null;
        }
        if (!webxmlResource.exists()) {
            Logger.debug("No deployment descriptor '{}' does not exists", webxmlResource.getLocation());
            return null;
        }
        try {
            String expression = "//servlet-mapping[servlet-name=\"" + applicationTypeName + "\"]";
            Node servletMappingNode = WtpUtils.evaluateXPathExpression(webxmlResource, expression);
            if (servletMappingNode != null) {
                StringWriter writer = new StringWriter();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(servletMappingNode), new StreamResult(writer));
                String servletMappingXml = writer.toString();
                Logger.debug("Found matching servlet-mapping: {}", servletMappingXml);
                InputStream contents = ((IFile)webxmlResource).getContents();
                int offset = WtpUtils.findLocation(contents, servletMappingXml);
                if (offset != -1) {
                    int length = servletMappingXml.length();
                    return new SourceRange(offset - length + 1, length);
                }
                return new SourceRange(0, 0);
            }
        }
        catch (Exception e) {
            Logger.error("Unable to parse file '" + webxmlResource.getProjectRelativePath().toOSString() + "' to find <servlet-mapping> elements", e);
        }
        Logger.debug("No servlet mapping found for class '{}' in file '{}'", applicationTypeName, webxmlResource.getProjectRelativePath());
        return null;
    }

    private static int findLocation(InputStream stream, String searchString) throws IOException {
        char[] buffer = new char[1024];
        int location = -1;
        int count = 0;
        try (InputStreamReader reader = null;){
            int numCharsRead;
            reader = new InputStreamReader(stream);
            while ((numCharsRead = reader.read(buffer)) > 0) {
                int c = 0;
                while (c < numCharsRead) {
                    ++location;
                    count = buffer[c] == searchString.charAt(count) ? ++count : 0;
                    if (count == searchString.length()) {
                        int n = location;
                        return n;
                    }
                    ++c;
                }
            }
            return -1;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Node evaluateXPathExpression(IResource webxmlResource, String expression) {
        Node servletMapping;
        if (webxmlResource == null || !webxmlResource.exists()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(false);
        dbf.setValidating(false);
        dbf.setFeature("http://xml.org/sax/features/namespaces", false);
        dbf.setFeature("http://xml.org/sax/features/validation", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        fileInputStream = new FileInputStream(webxmlResource.getLocation().toFile());
        InputSource inputSource = new InputSource(fileInputStream);
        Document doc = builder.parse(inputSource);
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile(expression);
        Node node = servletMapping = (Node)expr.evaluate(doc, XPathConstants.NODE);
        if (fileInputStream == null) return node;
        try {
            fileInputStream.close();
            return node;
        }
        catch (IOException iOException) {}
        return node;
        catch (Exception e) {
            try {
                Logger.error("Error while analyzing web deployment descriptor", e);
                if (fileInputStream == null) return null;
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                fileInputStream.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    public static boolean isWebDeploymentDescriptor(IResource resource) {
        IFolder webinfFolder = WtpUtils.getWebInfFolder(resource.getProject());
        if (webinfFolder == null) {
            return false;
        }
        IFile file = webinfFolder.getFile("web.xml");
        if (file == null) {
            return false;
        }
        return resource.getFullPath().equals((Object)file.getFullPath());
    }

    public static boolean hasWebDeploymentDescriptor(IProject project) {
        IFolder webinfFolder;
        long startTime;
        block3: {
            startTime = System.currentTimeMillis();
            try {
                webinfFolder = WtpUtils.getWebInfFolder(project);
                if (webinfFolder != null) break block3;
            }
            catch (Throwable throwable) {
                Logger.tracePerf("Looked-up Web Deployment Description in {}ms", System.currentTimeMillis() - startTime);
                throw throwable;
            }
            Logger.tracePerf("Looked-up Web Deployment Description in {}ms", System.currentTimeMillis() - startTime);
            return false;
        }
        IFile file = webinfFolder.getFile("web.xml");
        boolean bl = file != null && file.exists();
        Logger.tracePerf("Looked-up Web Deployment Description in {}ms", System.currentTimeMillis() - startTime);
        return bl;
    }

    public static IFile getWebDeploymentDescriptor(IProject project) throws CoreException {
        IFolder webinfFolder = WtpUtils.getWebInfFolder(project);
        IFile file = webinfFolder.getFile("web.xml");
        if (file != null && file.exists()) {
            return (IFile)project.findMember(file.getProjectRelativePath());
        }
        return null;
    }
}

