/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.cnf;

import java.util.Iterator;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.ui.JBossJaxrsUIPlugin;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriMappingsContentProvider;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriMappingsLabelProviderMessages;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateCategory;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateElement;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateMediaTypeMappingElement;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateMethodMappingElement;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;

public class UriMappingsLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
ILabelProvider {
    public Image getImage(Object element) {
        if (element instanceof UriPathTemplateCategory) {
            return JBossJaxrsUIPlugin.getDefault().getImage("restful_web_services.gif", ((UriPathTemplateCategory)element).getProblemLevel());
        }
        if (element instanceof UriPathTemplateElement) {
            return JBossJaxrsUIPlugin.getDefault().getImage("url_mapping.gif", ((UriPathTemplateElement)element).getProblemLevel());
        }
        if (element instanceof UriPathTemplateMediaTypeMappingElement) {
            switch (((UriPathTemplateMediaTypeMappingElement)element).getType()) {
                case CONSUMES: {
                    return JBossJaxrsUIPlugin.getDefault().getImage("filter_mapping_in.gif");
                }
                case PRODUCES: {
                    return JBossJaxrsUIPlugin.getDefault().getImage("filter_mapping_out.gif");
                }
            }
        } else {
            if (element instanceof UriPathTemplateMethodMappingElement) {
                return JBossJaxrsUIPlugin.getDefault().getImage("request_mapping_obj.gif");
            }
            if (element instanceof UriMappingsContentProvider.LoadingStub) {
                return JBossJaxrsUIPlugin.getDefault().getImage("systemprocess.gif");
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof UriPathTemplateCategory) {
            return new StyledString(UriMappingsLabelProviderMessages.JAXRS_WEB_SERVICES);
        }
        if (element instanceof UriPathTemplateElement) {
            IJaxrsEndpoint endpoint = ((UriPathTemplateElement)element).getEndpoint();
            StringBuilder sb = new StringBuilder();
            String httpVerb = endpoint.getHttpMethod().getHttpVerb();
            String uriTemplate = endpoint.getUriPathTemplate();
            sb.append(httpVerb);
            sb.append(" ");
            sb.append(uriTemplate);
            StyledString styledString = new StyledString(sb.toString());
            styledString.setStyle(0, httpVerb.length(), StyledString.QUALIFIER_STYLER);
            Logger.debug("URI Path Template: {}", styledString.getString());
            return styledString;
        }
        if (element instanceof UriPathTemplateMediaTypeMappingElement) {
            UriPathTemplateMediaTypeMappingElement mappingElement = (UriPathTemplateMediaTypeMappingElement)element;
            StringBuilder sb = new StringBuilder();
            int offset = 0;
            switch (((UriPathTemplateMediaTypeMappingElement)element).getType()) {
                case CONSUMES: {
                    sb.append(UriMappingsLabelProviderMessages.CONSUMED_MEDIATYPES);
                    offset = sb.length();
                    break;
                }
                case PRODUCES: {
                    sb.append(UriMappingsLabelProviderMessages.PRODUCED_MEDIATYPES);
                    offset = sb.length();
                }
            }
            Iterator<String> iterator = mappingElement.getMediaTypes().iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            StyledString styledString = new StyledString(sb.toString());
            styledString.setStyle(0, offset, StyledString.QUALIFIER_STYLER);
            return styledString;
        }
        if (element instanceof UriPathTemplateMethodMappingElement) {
            IJaxrsResourceMethod lastMethod = ((UriPathTemplateMethodMappingElement)element).getResourceMethod();
            StringBuilder sb = new StringBuilder();
            IMethod javaMethod = lastMethod.getJavaElement();
            sb.append(javaMethod.getParent().getElementName()).append(".").append(javaMethod.getElementName()).append("(...)");
            return new StyledString(sb.toString());
        }
        if (element instanceof UriMappingsContentProvider.LoadingStub) {
            String message = UriMappingsLabelProviderMessages.LOADING_CONTENT;
            StyledString styledString = new StyledString(message);
            styledString.setStyle(0, message.length(), StyledString.DECORATIONS_STYLER);
            return new StyledString(message);
        }
        return null;
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }
}

