/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.contentassist;

import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;

public class MemberDeclarationVisitor
extends ASTVisitor {
    private final IMember member;
    private String sourceOverview;

    public MemberDeclarationVisitor(IMember member) {
        this.member = member;
    }

    public String getSourceOverview() {
        return this.sourceOverview;
    }

    public boolean visit(MethodDeclaration node) {
        if (this.sourceOverview == null) {
            try {
                ISourceRange sourceRange = this.member.getSourceRange();
                int memberStartPosition = sourceRange.getOffset();
                int memberEndPosition = memberStartPosition + sourceRange.getLength();
                int nodeStartPosition = node.getStartPosition();
                if (memberStartPosition <= nodeStartPosition && nodeStartPosition <= memberEndPosition) {
                    Javadoc javaDoc = node.getJavadoc();
                    Block body = node.getBody();
                    node.getLocationInParent();
                    int beginIndex = javaDoc != null ? javaDoc.getStartPosition() + javaDoc.getLength() : this.member.getSourceRange().getOffset();
                    this.sourceOverview = this.member.getCompilationUnit().getSource().substring(beginIndex, body.getStartPosition()).trim();
                }
            }
            catch (JavaModelException e) {
                Logger.warn("Failed to visit node", e);
            }
        }
        return super.visit(node);
    }
}

