/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceField;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceProperty;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.AnnotationUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsProvider;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceField;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceProperty;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.AbstractJaxrsElementValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IMarkerManager;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsResourceFieldValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsResourceMethodValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsResourcePropertyValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsValidationMessages;
import org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsPreferences;

public class JaxrsResourceValidatorDelegate
extends AbstractJaxrsElementValidatorDelegate<JaxrsResource> {
    public JaxrsResourceValidatorDelegate(IMarkerManager markerManager) {
        super(markerManager);
    }

    @Override
    void internalValidate(JaxrsResource resource, CompilationUnit ast) throws CoreException {
        Logger.debug("Validating element {}", resource);
        this.validatePathAnnotationValue(resource, ast);
        this.validateAtLeastOneProviderWithBinding(resource);
        for (IJaxrsResourceMethod resourceMethod : resource.getAllMethods()) {
            new JaxrsResourceMethodValidatorDelegate(this.markerManager).validate((JaxrsResourceMethod)resourceMethod, ast);
        }
        for (IJaxrsResourceField resourceField : resource.getAllFields()) {
            new JaxrsResourceFieldValidatorDelegate(this.markerManager).validate((JaxrsResourceField)resourceField, ast);
        }
        for (IJaxrsResourceProperty resourceProperty : resource.getAllProperties()) {
            new JaxrsResourcePropertyValidatorDelegate(this.markerManager).validate((JaxrsResourceProperty)resourceProperty, ast);
        }
    }

    private void validatePathAnnotationValue(JaxrsResource resource, CompilationUnit ast) throws JavaModelException, CoreException {
        Annotation pathAnnotation = resource.getPathAnnotation();
        if (pathAnnotation != null && pathAnnotation.getValue() != null && !AnnotationUtils.isValidAnnotationValue((String)pathAnnotation.getValue())) {
            ISourceRange range = JdtUtils.resolveMemberPairValueRange((IAnnotation)pathAnnotation.getJavaAnnotation(), (String)"value", (CompilationUnit)ast);
            this.markerManager.addMarker((JaxrsBaseElement)resource, range, JaxrsValidationMessages.RESOURCE_INVALID_PATH_ANNOTATION_VALUE, new String[]{pathAnnotation.getValue()}, JaxrsPreferences.RESOURCE_INVALID_PATH_ANNOTATION_VALUE);
        }
    }

    private void validateAtLeastOneProviderWithBinding(JaxrsResource resource) throws CoreException {
        if (resource == null) {
            return;
        }
        Map nameBindingAnnotations = resource.getNameBindingAnnotations();
        if (nameBindingAnnotations.isEmpty()) {
            return;
        }
        JaxrsMetamodel metamodel = resource.getMetamodel();
        block0: for (Map.Entry entry : nameBindingAnnotations.entrySet()) {
            String nameBindingAnnotationClassName = (String)entry.getKey();
            Set annotatedProviders = metamodel.findProvidersByAnnotation(nameBindingAnnotationClassName);
            for (IJaxrsProvider provider : annotatedProviders) {
                if (resource.getNameBindingAnnotations().keySet().containsAll(provider.getNameBindingAnnotations().keySet())) continue block0;
            }
            ISourceRange nameRange = ((Annotation)entry.getValue()).getJavaAnnotation().getNameRange();
            this.markerManager.addMarker((JaxrsBaseElement)resource, nameRange, JaxrsValidationMessages.PROVIDER_MISSING_BINDING, new String[]{nameBindingAnnotationClassName}, JaxrsPreferences.PROVIDER_MISSING_BINDING);
        }
    }

    private void validateConstructorParameters() {
    }
}

