/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.view;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.ws.jaxrs.ui.JBossJAXRSUIMessages;
import org.jboss.tools.ws.jaxrs.ui.JBossJaxrsUIPlugin;
import org.jboss.tools.ws.jaxrs.ui.utils.JAXRSTester;
import org.jboss.tools.ws.jaxrs.ui.view.JAXRSTestEntry;
import org.jboss.tools.ws.jaxrs.ui.view.RequestHeadersAndParamsComposite;
import org.jboss.tools.ws.jaxrs.ui.view.WSTesterURLInputsDialog;
import org.jboss.tools.ws.ui.utils.WSTestUtils;
import org.jboss.tools.ws.ui.views.CustomTestEntry;
import org.jboss.tools.ws.ui.views.RequestBodyComposite;
import org.jboss.tools.ws.ui.views.TestEntry;
import org.jboss.tools.ws.ui.views.WSTestStatus;
import org.jboss.tools.ws.ui.views.WSType;
import org.jboss.tools.ws.ui.views.WebServicesTestView;

public abstract class JAXRSType
implements WSType {
    private RequestHeadersAndParamsComposite headersAndParams;
    private RequestBodyComposite body;
    protected WebServicesTestView view;

    public IStatus handleWSTest(IProgressMonitor monitor, String url, String uid, String pwd) {
        if (url.endsWith("}")) {
            OpenInputsDialogRunnable inputsDialog = new OpenInputsDialogRunnable(url);
            Display.getDefault().syncExec((Runnable)inputsDialog);
            if (!inputsDialog.isOk) {
                return Status.OK_STATUS;
            }
            url = inputsDialog.getUrl();
        }
        JAXRSTester tester = new JAXRSTester();
        try {
            JBossJaxrsUIPlugin.getDefault().countRequestSubmitted(this.getType());
            JAXRSTestEntry entry = JAXRSType.getRSTestEntry(this.view.getCurrentEntry());
            String requestBody = null;
            if (this.requestBody()) {
                RequestBodyRunnable runnable = new RequestBodyRunnable();
                Display.getDefault().syncExec((Runnable)runnable);
                requestBody = runnable.getRequestBody();
            }
            tester.doTest(url, entry.getRequestParams(), entry.getRequestHeaders(), this.getType(), requestBody, null, -1, uid, pwd);
            String result = tester.getResultBody();
            String cleanedUp = WSTestUtils.addNLsToXML((String)result);
            WSTestStatus status = new WSTestStatus(0, "org.jboss.tools.ws.jaxrs.ui", JBossJAXRSUIMessages.JAXRSWSTestView_JAXRS_Success_Status);
            status.setResultsText(cleanedUp);
            status.setHeaders(tester.getResultHeaders());
            monitor.worked(10);
            return status;
        }
        catch (Exception e) {
            return new WSTestStatus(4, "org.jboss.tools.ws.jaxrs.ui", e.getMessage());
        }
    }

    public void fillAdditionalRequestDetails(Composite parent) {
        this.headersAndParams = new RequestHeadersAndParamsComposite();
        this.headersAndParams.createControl(this.view, parent);
        if (this.requestBody()) {
            this.body = new RequestBodyComposite();
            this.body.createControl(this.view, parent);
        }
    }

    public void setWebServicesView(WebServicesTestView view) {
        this.view = view;
    }

    public List<IAction> getAdditonalToolActions() {
        return null;
    }

    public abstract boolean requestBody();

    public static JAXRSTestEntry getRSTestEntry(TestEntry entry) {
        CustomTestEntry customEntry = entry.getCustomEntry();
        if (!(customEntry instanceof JAXRSTestEntry)) {
            customEntry = new JAXRSTestEntry();
            entry.setCustomEntry(customEntry);
        }
        return (JAXRSTestEntry)customEntry;
    }

    public void updateControlsForSelectedEntry(TestEntry entry) {
        JAXRSTestEntry rsEntry = JAXRSType.getRSTestEntry(entry);
        this.headersAndParams.setHeadersAndParamsValues(rsEntry);
        if (this.body != null) {
            this.body.setBodyText(rsEntry.getBody());
        }
    }

    class OpenInputsDialogRunnable
    implements Runnable {
        private String url;
        private boolean isOk;
        private WSTesterURLInputsDialog dialog;

        public OpenInputsDialogRunnable(String url) {
            this.url = url;
        }

        @Override
        public void run() {
            this.dialog = new WSTesterURLInputsDialog(JAXRSType.this.view.getSite().getShell(), this.url);
            int rtn_code = this.dialog.open();
            if (rtn_code == 0) {
                JAXRSType.this.view.setURL(this.dialog.getURL());
                this.isOk = true;
            } else {
                this.isOk = false;
            }
        }

        public boolean isOk() {
            return this.isOk;
        }

        public String getUrl() {
            return this.dialog.getURL();
        }
    }

    class RequestBodyRunnable
    implements Runnable {
        private String requestBody;

        RequestBodyRunnable() {
        }

        @Override
        public void run() {
            this.requestBody = JAXRSType.this.body.getBodyText();
        }

        public String getRequestBody() {
            return this.requestBody;
        }
    }
}

